# LibRaw
## Library for reading and processing of RAW digicam images

 The LibRaw library provides a simple and unified interface for extracting out of RAW files generated by digital photo cameras the following:

* RAW data (_pixel values)_
* Metadata necessary for processing RAW (_geometry, CFA / Bayer pattern, black level, white balance, etc.)_
* Embedded preview / thumbnail.

The library is intended for use with programs that work with RAW files, such as:

* RAW viewers
* RAW converters
* RAW data analyzers
* Software for stitching and compositing multi-frame aggregates like panoramas and image stacks.

Using the LibRaw library allows one to focus on the substantive part of processing the data contained in RAW files, without getting distracted by the wide variety of RAW file and metadata formats, compression algorithms, etc.

The librarys development is focused on:

* Support for new cameras and formats
* Improving extraction of metadata necessary for RAW processing
* Providing an interface for reading other types of metadata.

Additionally, the LibRaw library offers some basic RAW conversion, intended for cases when such conversion is not the main function of the LibRaw-using application _(for example: a viewer for 500+ graphic file formats, including RAW)._ These methods are inherited from the Dave Coffins dcraw.c utility _(see below the Project history section);_ their further development is not currently planned, because we do not consider production-quality rendering to be in the scope of LibRaws functionality _(the methods are retained for compatibility with prior versions and for rapid-fire testing of RAW support and other aspects)._

## Licensing


The LibRaw library is distributed free of charge and with open-source code subject to two licenses:

1\. GNU LESSER GENERAL PUBLIC LICENSE version 2.1

2\. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0

To use the LibRaw library in an application, you can choose the license that better suits your needs.

If you modify/add/improve the LibRaw source code, then your patches can only be included into the librarys official source code if you agree to it being distributed under both of the above licenses.

We do not guarantee that the licensing will not change in future versions of LibRaw.

## Update policy


### Major/minor releases

* Major releases _(for example, 0.20)_ are published once every year and a half to two years.
* When the first public beta version of a major release is published, the list of supported cameras and formats is frozen; we try (but do not guarantee) to freeze the API/ABI as well.
* The public major release contains only that code which has been sufficiently tested on a wide user base (including in our commercial products). Something very new may not be included in it (but it will probably be included in a public snapshot, see below).
* Minor updates _(0.20.1, 0.20.2)_ do not change the API/ABI and new cameras are not added; generally they are just bugfixes.
* Bugfixes are published as soon as possible in the [public GitHub repository](https://github.com/LibRaw/LibRaw).
* Minor version increments: these are generally published if a serious error has been fixed, one that potentially affects many library users (for example, a possible stack overflow).

### Public snapshots

* Public snapshots are published every 7-9 months in the [public GitHub repository](https://github.com/LibRaw/LibRaw).
* These versions contain support for new cameras that was added after the previous major release. The API/ABI of public snapshots is not frozen, and may change.
* Public snapshots are always tested on a fairly large user base, and may be considered suitable for use in programs that work with files with known origins (that is, recorded directly by users digital cameras). However, public snapshots should not be considered sufficiently reliable for processing files that are specially constructed for vulnerability testing; that is, they should not be used in public services that allow for anonymous processing of files of unknown provenance

## Support and feedback

* You can submit a bug report in one of the following ways:
    * [Issues](https://github.com/LibRaw/LibRaw/issues) on GitHub
    * The libraw.org [forum](https://www.libraw.org/forum)
    * [Feedback form](https://www.libraw.org/contact) on libraw.org
    * E-mail us at [info@libraw.org](mailto:info@libraw.org)
* Questions can be asked on the forum, through the feedback form, and via the email indicated above.  
    Please do not use Issues on GitHub for questions; it is intended specifically for problem reports.
* We prefer to process additions to the source code via the [Pull Requests](https://github.com/LibRaw/LibRaw/pulls) on GitHub.

We cannot guarantee any response to requests submitted via the above methods. If you need a guaranteed response for a bug report and/or for extending technical support, please use the Extended Support option.

## Project history


The LibRaw project was launched in 2008, based on the [dcraw.c](https://www.dechifro.org/dcraw/) (Dave Coffin) utility, with its goals being to:

* Convert dcraw.c into a library that could be used by other programs, while also somewhat improving the structure of dcraw.c (removing global variables, making it thread-safe, etc.)
* Import changes made to dcraw.c
* Improve/expand the extraction of metadata.

Unfortunately, support for dcraw.c was reduced to a minimum in 2015, and completely ceased in 2018. Since then, support for new cameras (including support for new formats) has been done entirely by the LibRaw team.

The code that implements rendering of RAW to RGB is inherited from dcraw.c, without major changes (though a set of changes was implemented to speed up and parallelize this code).

In the early-to-mid 2010s, we gladly expanded post-processing implemented in LibRaw, and readily accepted the input of outside developers (new/improved methods for debayerization/demosaicing, systematic noise reduction etc.).

Experience has shown that the LibRaw team cannot support this added code on their own, while contributors do not provide support and development of the code they suggest and it ends up abandoned. As such, the majority of the modifications that are implemented by people outside the LibRaw team was moved to the [LibRaw-demosaic-pack-.](https://github.com/LibRaw?tab=repositories), where they remain in their original form (but these projects are still present in our GitHub).

Thus, we arrive at our current status, described in the first part of this text.

## Copyrights and Acknowledgements

Copyright (C) 2008-2021 LibRaw LLC

LibRaw uses code from Dave Coffins dcraw.c utility (without RESTRICTED/GPL2 code):

Copyright 1997-2018 by Dave Coffin, dcoffin a cybercom o net

LibRaw uses DCB demosaic code by Jaceck Gozdz distributed under BSD license:

Copyright (C) 2010, Jacek Gozdz (mailto:cuniek@kft.umcs.lublin.pl)

LibRaw uses Roland Karlssons X3F tools source code, licensed under BSD license:

Copyright (c) 2010, Roland Karlsson (roland@proxel.se)