% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbDataType}
\alias{dbDataType}
\alias{dbDataType,DBIObject-method}
\title{Determine the SQL data type of an object.}
\usage{
dbDataType(dbObj, obj, ...)
}
\arguments{
\item{dbObj}{A object inheriting from \code{\linkS4class{DBIDriver}}}

\item{obj}{An R object whose SQL type we want to determine.}

\item{...}{Other arguments passed on to methods.}
}
\value{
A character string specifying the SQL data type for \code{obj}.
}
\description{
This is a generic function. The default method determines the SQL type of an
R object according to the SQL 92 specification, which may serve as a starting
point for driver implementations. The default method also provides a method
for data.frame which will return a character vector giving the type for each
column in the dataframe.
}
\details{
The data types supported by databases are different than the data types in R,
but the mapping between the primitve types is straightforward:  Any of the
many fixed and varying length character types are mapped to character
vectors. Fixed-precision (non-IEEE) numbers are mapped into either numeric or
integer vectors.

Notice that many DBMS do not follow IEEE arithmetic, so there are potential
problems with under/overflows and loss of precision.
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbDataType(con, 1:5)
dbDataType(con, 1L)
dbDataType(con, TRUE)
dbDataType(con, c("x", "abc"))

dbDataType(con, mtcars)
}
}
\seealso{
\code{\link{isSQLKeyword}} \code{\link{make.db.names}}
}

