/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __ui
#define __ui

#include <string>

struct ui {

  std::string name;
  int id;
  int prev_mousex, prev_mousey;

  virtual void enter () {}
  virtual void leave () {}
  virtual bool handle_input() {return true;}
  virtual void calc_win_mouse () {}
  virtual void draw() {}
  virtual void bg () {}
  ui () { prev_mousex = prev_mousey = -1;}
  virtual ~ui () {}

};

#endif
