/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteSource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public final class PackSource
implements ByteSource {
    private ByteSource bs = null;
    private int mode = 0;
    private File file = null;
    private Collection<PackRecord> packRecords = null;
    private long maxWritten = 0L;
    private Iterator<PackRecord> recordIt = null;
    private PackRecord currentRecord = null;
    private int payloadPosition = 0;
    private int recordLimit = 0;
    private boolean recordLimited = false;
    private LinkedList<Window> windows = new LinkedList();
    private Window currentWindow = null;
    private long physicalPosition = 0L;

    public PackSource(ByteSource bs, int mode, File file, Collection<PackRecord> packRecords) throws IOException {
        this.bs = bs;
        this.mode = mode;
        this.file = file;
        this.packRecords = packRecords;
        for (PackRecord this.currentRecord : packRecords) {
        }
        this.currentWindow = new Window(0L, this.currentRecord.dataOffset + (long)this.currentRecord.payloadSize);
        this.windows.add(this.currentWindow);
        this.recordIt = packRecords.iterator();
        this.currentRecord = this.recordIt.next();
        this.recordLimit = this.currentRecord.payloadSize;
        this.physicalPosition = this.currentRecord.packetOffset + (long)this.currentRecord.payloadOffset;
        bs.setPosition(this.physicalPosition);
    }

    @Override
    public int read(byte[] dst, int offset, int length) throws IOException {
        if (this.mode == 0 || this.mode == 2) {
            return this.readWrite(dst, offset, length, false);
        }
        throw new IOException("PackSource not opened for reading");
    }

    @Override
    public int write(byte[] src, int offset, int length) throws IOException {
        if (this.mode == 1 || this.mode == 2) {
            return this.readWrite(src, offset, length, true);
        }
        throw new IOException("PackSource not opened for writing");
    }

    @Override
    public long getPosition() throws IOException {
        return this.currentRecord.dataOffset + (long)this.payloadPosition - this.currentWindow.start;
    }

    @Override
    public void setPosition(long position) throws IOException {
        long tPosition = this.currentWindow.start + position;
        if (tPosition >= this.currentWindow.start && tPosition <= this.currentWindow.end) {
            if (tPosition >= this.currentRecord.dataOffset && tPosition <= this.currentRecord.dataOffset + (long)this.currentRecord.payloadSize) {
                this.payloadPosition = (int)(tPosition - this.currentRecord.dataOffset);
            } else {
                this.recordIt = this.packRecords.iterator();
                this.currentRecord = this.recordIt.next();
                while (tPosition > this.currentRecord.dataOffset + (long)this.currentRecord.payloadSize) {
                    if (this.recordIt.hasNext()) {
                        this.currentRecord = this.recordIt.next();
                        continue;
                    }
                    throw new IOException("Unexpected EOF");
                }
                this.payloadPosition = (int)(tPosition - this.currentRecord.dataOffset);
                this.updateLimit();
            }
        } else {
            throw new IOException("Seek exceeds window limits");
        }
        this.physicalPosition = this.currentRecord.packetOffset + (long)this.currentRecord.payloadOffset + (long)this.payloadPosition;
        this.bs.setPosition(this.physicalPosition);
    }

    @Override
    public int windowCount() {
        return this.windows.size() - 1;
    }

    @Override
    public void addWindow(long size) throws IOException {
        long start = this.currentRecord.dataOffset + (long)this.payloadPosition;
        long end = start + size;
        if (end > this.currentWindow.end) {
            throw new IOException("New window exceeds current window limits");
        }
        this.currentWindow = new Window(start, end);
        this.windows.add(this.currentWindow);
        this.updateLimit();
    }

    @Override
    public void removeWindow() throws IOException {
        if (this.windows.size() <= 1) {
            throw new IOException("No window set");
        }
        this.windows.removeLast();
        this.currentWindow = this.windows.getLast();
        this.updateLimit();
    }

    @Override
    public long size() throws IOException {
        return this.currentWindow.end - this.currentWindow.start;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        this.bs = null;
        this.file = null;
        this.currentRecord = null;
        this.recordIt = null;
        this.packRecords = null;
        this.currentWindow = null;
        this.windows = null;
    }

    public long maxWrittenPosition() {
        return this.maxWritten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readWrite(byte[] data, int offset, int length, boolean write) throws IOException {
        int transferred = 0;
        if (this.bs.getPosition() != this.physicalPosition) {
            this.bs.setPosition(this.physicalPosition);
        }
        while (true) {
            long newMaxWritten;
            int remaining;
            if (length <= (remaining = this.recordLimit - this.payloadPosition)) {
                if (write) {
                    if (this.bs.write(data, offset, length) != length) throw new IOException("Unexpected EOF");
                    this.payloadPosition += length;
                    newMaxWritten = this.currentRecord.dataOffset + (long)this.payloadPosition;
                    if (newMaxWritten > this.maxWritten) {
                        this.maxWritten = newMaxWritten;
                    }
                } else {
                    if (this.bs.read(data, offset, length) != length) throw new IOException("Unexpected EOF");
                    this.payloadPosition += length;
                }
                this.physicalPosition += (long)length;
                transferred += length;
                return transferred;
            }
            if (remaining > 0) {
                if (write) {
                    if (this.bs.write(data, offset, remaining) != remaining) throw new IOException("Unexpected EOF");
                    this.payloadPosition += remaining;
                    newMaxWritten = this.currentRecord.dataOffset + (long)this.payloadPosition;
                    if (newMaxWritten > this.maxWritten) {
                        this.maxWritten = newMaxWritten;
                    }
                } else {
                    if (this.bs.read(data, offset, remaining) != remaining) throw new IOException("Unexpected EOF");
                    this.payloadPosition += remaining;
                }
                this.physicalPosition += (long)remaining;
                offset += remaining;
                length -= remaining;
                transferred += remaining;
            }
            if (this.recordLimited) {
                if (transferred != 0) return transferred;
                return -1;
            }
            if (!this.recordIt.hasNext()) throw new IOException("Unexpected EOF");
            this.currentRecord = this.recordIt.next();
            this.payloadPosition = 0;
            this.updateLimit();
            this.physicalPosition = this.currentRecord.packetOffset + (long)this.currentRecord.payloadOffset;
            this.bs.setPosition(this.physicalPosition);
        }
    }

    private void updateLimit() {
        long checkLimit = this.currentWindow.end - this.currentRecord.dataOffset;
        if (checkLimit <= (long)this.currentRecord.payloadSize) {
            this.recordLimited = true;
            this.recordLimit = (int)checkLimit;
        } else {
            this.recordLimited = false;
            this.recordLimit = this.currentRecord.payloadSize;
        }
    }

    public static final class PackRecord {
        public long dataOffset = 0L;
        public long packetOffset = 0L;
        public int payloadOffset = 0;
        public int payloadSize = 0;

        public PackRecord() {
        }

        public PackRecord(long dataOffset, long packetOffset, int payloadOffset, int payloadSize) {
            this.dataOffset = dataOffset;
            this.packetOffset = packetOffset;
            this.payloadOffset = payloadOffset;
            this.payloadSize = payloadSize;
        }

        public String toString() {
            return String.format("PackRecord :: dataOffset: 0x%1$010X, packetOffset: 0x%2$010X, payloadOffset: 0x%3$04X, payloadSize: 0x%4$04X", this.dataOffset, this.packetOffset, this.payloadOffset, this.payloadSize);
        }
    }

    private static final class Window {
        public long start = 0L;
        public long end = Long.MAX_VALUE;

        public Window() {
        }

        public Window(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("Window :: start: ");
            sb.append(this.start);
            sb.append(", end: ");
            sb.append(this.end);
            return sb.toString();
        }
    }
}

