/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_GNOME
#ifndef _vdkb_gnomeentry_h
#define _vdkb_gnomeentry_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>
#include <vdkb2/vdkb_widpopmenu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBGnomeEntry: public VDKGnomeEntry, public VDKBObject
{

 protected:
  bool EntryButtonPressed(VDKObject* sender,GdkEvent* ev);
  VDKBWidgetPopMenu *popmenu;
  VDKBObjectInspector* inspector;
  VDKCheckButton *editable,*sorted,*hidden,*casesensitive;
  VDKEntry *history;
  VDKSpinButton *max_saved;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner,
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBGnomeEntry(char* name,VDKForm* owner);
  virtual ~VDKBGnomeEntry() {}
   virtual int Type() { return vdkbclass_gnomeentry; }
  virtual char* VDKName() { return "VDKGnomeEntry"; }
  virtual int isA() { return vdkbclass_gnomeentry; }
  void PopMenu() { popmenu->Popup(); }
  VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  // designer
  bool OnSetEditable(VDKObject*);
  bool OnSetSorted(VDKObject*);
  bool OnSetHidden(VDKObject*);
  bool OnSetHistory(VDKObject*);
  bool OnSetMaxSaved(VDKObject*);
  bool OnSetCaseSensitive(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBGnomeEntry);
  DECLARE_EVENT_LIST(VDKBGnomeEntry);
};
#endif
#endif
