/*
 * Copyright (C) 2015-2017 Socionext Inc.
 *   Author: Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program5 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-uniphier.h"

static const struct pinctrl_pin_desc uniphier_pro4_pins[] = {
	UNIPHIER_PINCTRL_PIN(0, "CK24O", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_1BIT,
			     0, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(1, "VC27A", UNIPHIER_PIN_IECTRL_NONE,
			     1, UNIPHIER_PIN_DRV_1BIT,
			     1, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(2, "CK27AI", UNIPHIER_PIN_IECTRL_NONE,
			     2, UNIPHIER_PIN_DRV_1BIT,
			     2, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(3, "CK27AO", UNIPHIER_PIN_IECTRL_NONE,
			     3, UNIPHIER_PIN_DRV_1BIT,
			     3, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(4, "CKSEL", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_1BIT,
			     4, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(5, "CK27AV", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_1BIT,
			     5, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(6, "AEXCKA", UNIPHIER_PIN_IECTRL_NONE,
			     6, UNIPHIER_PIN_DRV_1BIT,
			     6, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(7, "ASEL", UNIPHIER_PIN_IECTRL_NONE,
			     7, UNIPHIER_PIN_DRV_1BIT,
			     7, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(8, "ARCRESET", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_1BIT,
			     8, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(9, "ARCUNLOCK", UNIPHIER_PIN_IECTRL_NONE,
			     9, UNIPHIER_PIN_DRV_1BIT,
			     9, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(10, "XSRST", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_1BIT,
			     10, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(11, "XNMIRQ", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_1BIT,
			     11, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(12, "XSCIRQ", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_1BIT,
			     12, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(13, "EXTRG", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_1BIT,
			     13, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(14, "TRCCLK", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_1BIT,
			     14, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(15, "TRCCTL", UNIPHIER_PIN_IECTRL_NONE,
			     15, UNIPHIER_PIN_DRV_1BIT,
			     15, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(16, "TRCD0", UNIPHIER_PIN_IECTRL_NONE,
			     16, UNIPHIER_PIN_DRV_1BIT,
			     16, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(17, "TRCD1", UNIPHIER_PIN_IECTRL_NONE,
			     17, UNIPHIER_PIN_DRV_1BIT,
			     17, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(18, "TRCD2", UNIPHIER_PIN_IECTRL_NONE,
			     18, UNIPHIER_PIN_DRV_1BIT,
			     18, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(19, "TRCD3", UNIPHIER_PIN_IECTRL_NONE,
			     19, UNIPHIER_PIN_DRV_1BIT,
			     19, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(20, "TRCD4", UNIPHIER_PIN_IECTRL_NONE,
			     20, UNIPHIER_PIN_DRV_1BIT,
			     20, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(21, "TRCD5", UNIPHIER_PIN_IECTRL_NONE,
			     21, UNIPHIER_PIN_DRV_1BIT,
			     21, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(22, "TRCD6", UNIPHIER_PIN_IECTRL_NONE,
			     22, UNIPHIER_PIN_DRV_1BIT,
			     22, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(23, "TRCD7", UNIPHIER_PIN_IECTRL_NONE,
			     23, UNIPHIER_PIN_DRV_1BIT,
			     23, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(24, "XECS1", UNIPHIER_PIN_IECTRL_NONE,
			     24, UNIPHIER_PIN_DRV_1BIT,
			     24, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(25, "ERXW", UNIPHIER_PIN_IECTRL_NONE,
			     25, UNIPHIER_PIN_DRV_1BIT,
			     25, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(26, "XERWE0", UNIPHIER_PIN_IECTRL_NONE,
			     26, UNIPHIER_PIN_DRV_1BIT,
			     26, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(27, "XERWE1", UNIPHIER_PIN_IECTRL_NONE,
			     27, UNIPHIER_PIN_DRV_1BIT,
			     27, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(28, "ES0", UNIPHIER_PIN_IECTRL_NONE,
			     28, UNIPHIER_PIN_DRV_1BIT,
			     28, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(29, "ES1", UNIPHIER_PIN_IECTRL_NONE,
			     29, UNIPHIER_PIN_DRV_1BIT,
			     29, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(30, "ES2", UNIPHIER_PIN_IECTRL_NONE,
			     30, UNIPHIER_PIN_DRV_1BIT,
			     30, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(31, "ED0", UNIPHIER_PIN_IECTRL_NONE,
			     31, UNIPHIER_PIN_DRV_1BIT,
			     31, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(32, "ED1", UNIPHIER_PIN_IECTRL_NONE,
			     32, UNIPHIER_PIN_DRV_1BIT,
			     32, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(33, "ED2", UNIPHIER_PIN_IECTRL_NONE,
			     33, UNIPHIER_PIN_DRV_1BIT,
			     33, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(34, "ED3", UNIPHIER_PIN_IECTRL_NONE,
			     34, UNIPHIER_PIN_DRV_1BIT,
			     34, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(35, "ED4", UNIPHIER_PIN_IECTRL_NONE,
			     35, UNIPHIER_PIN_DRV_1BIT,
			     35, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(36, "ED5", UNIPHIER_PIN_IECTRL_NONE,
			     36, UNIPHIER_PIN_DRV_1BIT,
			     36, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(37, "ED6", UNIPHIER_PIN_IECTRL_NONE,
			     37, UNIPHIER_PIN_DRV_1BIT,
			     37, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(38, "ED7", UNIPHIER_PIN_IECTRL_NONE,
			     38, UNIPHIER_PIN_DRV_1BIT,
			     38, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(39, "BOOTSWAP", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_NONE,
			     39, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(40, "NFD0", UNIPHIER_PIN_IECTRL_NONE,
			     2, UNIPHIER_PIN_DRV_2BIT,
			     40, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(41, "NFD1", UNIPHIER_PIN_IECTRL_NONE,
			     3, UNIPHIER_PIN_DRV_2BIT,
			     41, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(42, "NFD2", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_2BIT,
			     42, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(43, "NFD3", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_2BIT,
			     43, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(44, "NFD4", UNIPHIER_PIN_IECTRL_NONE,
			     6, UNIPHIER_PIN_DRV_2BIT,
			     44, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(45, "NFD5", UNIPHIER_PIN_IECTRL_NONE,
			     7, UNIPHIER_PIN_DRV_2BIT,
			     45, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(46, "NFD6", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_2BIT,
			     46, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(47, "NFD7", UNIPHIER_PIN_IECTRL_NONE,
			     9, UNIPHIER_PIN_DRV_2BIT,
			     47, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(48, "NFALE", UNIPHIER_PIN_IECTRL_NONE,
			     48, UNIPHIER_PIN_DRV_1BIT,
			     48, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(49, "NFCLE", UNIPHIER_PIN_IECTRL_NONE,
			     49, UNIPHIER_PIN_DRV_1BIT,
			     49, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(50, "XNFRE", UNIPHIER_PIN_IECTRL_NONE,
			     50, UNIPHIER_PIN_DRV_1BIT,
			     50, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(51, "XNFWE", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_2BIT,
			     51, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(52, "XNFWP", UNIPHIER_PIN_IECTRL_NONE,
			     52, UNIPHIER_PIN_DRV_1BIT,
			     52, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(53, "XNFCE0", UNIPHIER_PIN_IECTRL_NONE,
			     1, UNIPHIER_PIN_DRV_2BIT,
			     53, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(54, "NRYBY0", UNIPHIER_PIN_IECTRL_NONE,
			     54, UNIPHIER_PIN_DRV_1BIT,
			     54, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(55, "DMDSCLTST", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_NONE,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(56, "DMDSDATST", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(57, "AGCI0", 3,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     55, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(58, "DMDSCL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(59, "DMDSDA0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(60, "AGCBS0", 5,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     56, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(61, "DMDSCL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(62, "DMDSDA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(63, "ANTSHORT", UNIPHIER_PIN_IECTRL_NONE,
			     57, UNIPHIER_PIN_DRV_1BIT,
			     57, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(64, "CH0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     58, UNIPHIER_PIN_DRV_1BIT,
			     58, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(65, "CH0VAL", UNIPHIER_PIN_IECTRL_NONE,
			     59, UNIPHIER_PIN_DRV_1BIT,
			     59, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(66, "CH0PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     60, UNIPHIER_PIN_DRV_1BIT,
			     60, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(67, "CH0DATA", UNIPHIER_PIN_IECTRL_NONE,
			     61, UNIPHIER_PIN_DRV_1BIT,
			     61, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(68, "CH1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     62, UNIPHIER_PIN_DRV_1BIT,
			     62, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(69, "CH1VAL", UNIPHIER_PIN_IECTRL_NONE,
			     63, UNIPHIER_PIN_DRV_1BIT,
			     63, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(70, "CH1PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     64, UNIPHIER_PIN_DRV_1BIT,
			     64, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(71, "CH1DATA", UNIPHIER_PIN_IECTRL_NONE,
			     65, UNIPHIER_PIN_DRV_1BIT,
			     65, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(72, "CH2CLK", UNIPHIER_PIN_IECTRL_NONE,
			     66, UNIPHIER_PIN_DRV_1BIT,
			     66, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(73, "CH2VAL", UNIPHIER_PIN_IECTRL_NONE,
			     67, UNIPHIER_PIN_DRV_1BIT,
			     67, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(74, "CH2PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     68, UNIPHIER_PIN_DRV_1BIT,
			     68, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(75, "CH2DATA", UNIPHIER_PIN_IECTRL_NONE,
			     69, UNIPHIER_PIN_DRV_1BIT,
			     69, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(76, "CH3CLK", UNIPHIER_PIN_IECTRL_NONE,
			     70, UNIPHIER_PIN_DRV_1BIT,
			     70, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(77, "CH3VAL", UNIPHIER_PIN_IECTRL_NONE,
			     71, UNIPHIER_PIN_DRV_1BIT,
			     71, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(78, "CH3PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     72, UNIPHIER_PIN_DRV_1BIT,
			     72, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(79, "CH3DATA", UNIPHIER_PIN_IECTRL_NONE,
			     73, UNIPHIER_PIN_DRV_1BIT,
			     73, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(80, "CH4CLK", UNIPHIER_PIN_IECTRL_NONE,
			     74, UNIPHIER_PIN_DRV_1BIT,
			     74, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(81, "CH4VAL", UNIPHIER_PIN_IECTRL_NONE,
			     75, UNIPHIER_PIN_DRV_1BIT,
			     75, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(82, "CH4PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     76, UNIPHIER_PIN_DRV_1BIT,
			     76, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(83, "CH4DATA", UNIPHIER_PIN_IECTRL_NONE,
			     77, UNIPHIER_PIN_DRV_1BIT,
			     77, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(84, "CH5CLK", UNIPHIER_PIN_IECTRL_NONE,
			     78, UNIPHIER_PIN_DRV_1BIT,
			     78, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(85, "CH5VAL", UNIPHIER_PIN_IECTRL_NONE,
			     79, UNIPHIER_PIN_DRV_1BIT,
			     79, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(86, "CH5PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     80, UNIPHIER_PIN_DRV_1BIT,
			     80, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(87, "CH5DATA", UNIPHIER_PIN_IECTRL_NONE,
			     81, UNIPHIER_PIN_DRV_1BIT,
			     81, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(88, "CH6CLK", UNIPHIER_PIN_IECTRL_NONE,
			     82, UNIPHIER_PIN_DRV_1BIT,
			     82, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(89, "CH6VAL", UNIPHIER_PIN_IECTRL_NONE,
			     83, UNIPHIER_PIN_DRV_1BIT,
			     83, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(90, "CH6PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     84, UNIPHIER_PIN_DRV_1BIT,
			     84, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(91, "CH6DATA", UNIPHIER_PIN_IECTRL_NONE,
			     85, UNIPHIER_PIN_DRV_1BIT,
			     85, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(92, "CKFEO", UNIPHIER_PIN_IECTRL_NONE,
			     86, UNIPHIER_PIN_DRV_1BIT,
			     86, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(93, "XFERST", UNIPHIER_PIN_IECTRL_NONE,
			     87, UNIPHIER_PIN_DRV_1BIT,
			     87, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(94, "P_FE_ON", UNIPHIER_PIN_IECTRL_NONE,
			     88, UNIPHIER_PIN_DRV_1BIT,
			     88, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(95, "P_TU0_ON", UNIPHIER_PIN_IECTRL_NONE,
			     89, UNIPHIER_PIN_DRV_1BIT,
			     89, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(96, "XFEIRQ0", UNIPHIER_PIN_IECTRL_NONE,
			     90, UNIPHIER_PIN_DRV_1BIT,
			     90, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(97, "XFEIRQ1", UNIPHIER_PIN_IECTRL_NONE,
			     91, UNIPHIER_PIN_DRV_1BIT,
			     91, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(98, "XFEIRQ2", UNIPHIER_PIN_IECTRL_NONE,
			     92, UNIPHIER_PIN_DRV_1BIT,
			     92, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(99, "XFEIRQ3", UNIPHIER_PIN_IECTRL_NONE,
			     93, UNIPHIER_PIN_DRV_1BIT,
			     93, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(100, "XFEIRQ4", UNIPHIER_PIN_IECTRL_NONE,
			     94, UNIPHIER_PIN_DRV_1BIT,
			     94, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(101, "XFEIRQ5", UNIPHIER_PIN_IECTRL_NONE,
			     95, UNIPHIER_PIN_DRV_1BIT,
			     95, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(102, "XFEIRQ6", UNIPHIER_PIN_IECTRL_NONE,
			     96, UNIPHIER_PIN_DRV_1BIT,
			     96, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(103, "SMTCLK0", UNIPHIER_PIN_IECTRL_NONE,
			     97, UNIPHIER_PIN_DRV_1BIT,
			     97, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(104, "SMTRST0", UNIPHIER_PIN_IECTRL_NONE,
			     98, UNIPHIER_PIN_DRV_1BIT,
			     98, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(105, "SMTCMD0", UNIPHIER_PIN_IECTRL_NONE,
			     99, UNIPHIER_PIN_DRV_1BIT,
			     99, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(106, "SMTD0", UNIPHIER_PIN_IECTRL_NONE,
			     100, UNIPHIER_PIN_DRV_1BIT,
			     100, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(107, "SMTSEL0", UNIPHIER_PIN_IECTRL_NONE,
			     101, UNIPHIER_PIN_DRV_1BIT,
			     101, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(108, "SMTDET0", UNIPHIER_PIN_IECTRL_NONE,
			     102, UNIPHIER_PIN_DRV_1BIT,
			     102, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(109, "SMTCLK1", UNIPHIER_PIN_IECTRL_NONE,
			     103, UNIPHIER_PIN_DRV_1BIT,
			     103, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(110, "SMTRST1", UNIPHIER_PIN_IECTRL_NONE,
			     104, UNIPHIER_PIN_DRV_1BIT,
			     104, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(111, "SMTCMD1", UNIPHIER_PIN_IECTRL_NONE,
			     105, UNIPHIER_PIN_DRV_1BIT,
			     105, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(112, "SMTD1", UNIPHIER_PIN_IECTRL_NONE,
			     106, UNIPHIER_PIN_DRV_1BIT,
			     106, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(113, "SMTSEL1", UNIPHIER_PIN_IECTRL_NONE,
			     107, UNIPHIER_PIN_DRV_1BIT,
			     107, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(114, "SMTDET1", UNIPHIER_PIN_IECTRL_NONE,
			     108, UNIPHIER_PIN_DRV_1BIT,
			     108, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(115, "XINTM", UNIPHIER_PIN_IECTRL_NONE,
			     109, UNIPHIER_PIN_DRV_1BIT,
			     109, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(116, "SCLKM", UNIPHIER_PIN_IECTRL_NONE,
			     110, UNIPHIER_PIN_DRV_1BIT,
			     110, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(117, "SBMTP", UNIPHIER_PIN_IECTRL_NONE,
			     111, UNIPHIER_PIN_DRV_1BIT,
			     111, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(118, "SBPTM", UNIPHIER_PIN_IECTRL_NONE,
			     112, UNIPHIER_PIN_DRV_1BIT,
			     112, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(119, "XMPREQ", UNIPHIER_PIN_IECTRL_NONE,
			     113, UNIPHIER_PIN_DRV_1BIT,
			     113, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(120, "XINTP", UNIPHIER_PIN_IECTRL_NONE,
			     114, UNIPHIER_PIN_DRV_1BIT,
			     114, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(121, "LPST", UNIPHIER_PIN_IECTRL_NONE,
			     115, UNIPHIER_PIN_DRV_1BIT,
			     115, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(122, "SDBOOT", UNIPHIER_PIN_IECTRL_NONE,
			     116, UNIPHIER_PIN_DRV_1BIT,
			     116, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(123, "BFAIL", UNIPHIER_PIN_IECTRL_NONE,
			     117, UNIPHIER_PIN_DRV_1BIT,
			     117, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(124, "XFWE", UNIPHIER_PIN_IECTRL_NONE,
			     118, UNIPHIER_PIN_DRV_1BIT,
			     118, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(125, "RF_COM_RDY", UNIPHIER_PIN_IECTRL_NONE,
			     119, UNIPHIER_PIN_DRV_1BIT,
			     119, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(126, "XDIAG0", UNIPHIER_PIN_IECTRL_NONE,
			     120, UNIPHIER_PIN_DRV_1BIT,
			     120, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(127, "RXD0", UNIPHIER_PIN_IECTRL_NONE,
			     121, UNIPHIER_PIN_DRV_1BIT,
			     121, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(128, "TXD0", UNIPHIER_PIN_IECTRL_NONE,
			     122, UNIPHIER_PIN_DRV_1BIT,
			     122, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(129, "RXD1", UNIPHIER_PIN_IECTRL_NONE,
			     123, UNIPHIER_PIN_DRV_1BIT,
			     123, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(130, "TXD1", UNIPHIER_PIN_IECTRL_NONE,
			     124, UNIPHIER_PIN_DRV_1BIT,
			     124, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(131, "RXD2", UNIPHIER_PIN_IECTRL_NONE,
			     125, UNIPHIER_PIN_DRV_1BIT,
			     125, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(132, "TXD2", UNIPHIER_PIN_IECTRL_NONE,
			     126, UNIPHIER_PIN_DRV_1BIT,
			     126, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(133, "SS0CS", UNIPHIER_PIN_IECTRL_NONE,
			     127, UNIPHIER_PIN_DRV_1BIT,
			     127, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(134, "SS0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     128, UNIPHIER_PIN_DRV_1BIT,
			     128, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(135, "SS0DO", UNIPHIER_PIN_IECTRL_NONE,
			     129, UNIPHIER_PIN_DRV_1BIT,
			     129, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(136, "SS0DI", UNIPHIER_PIN_IECTRL_NONE,
			     130, UNIPHIER_PIN_DRV_1BIT,
			     130, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(137, "MS0CS0", UNIPHIER_PIN_IECTRL_NONE,
			     131, UNIPHIER_PIN_DRV_1BIT,
			     131, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(138, "MS0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     132, UNIPHIER_PIN_DRV_1BIT,
			     132, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(139, "MS0DI", UNIPHIER_PIN_IECTRL_NONE,
			     133, UNIPHIER_PIN_DRV_1BIT,
			     133, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(140, "MS0DO", UNIPHIER_PIN_IECTRL_NONE,
			     134, UNIPHIER_PIN_DRV_1BIT,
			     134, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(141, "XMDMRST", UNIPHIER_PIN_IECTRL_NONE,
			     135, UNIPHIER_PIN_DRV_1BIT,
			     135, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(142, "SCL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(143, "SDA0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(144, "SCL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(145, "SDA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(146, "SCL2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(147, "SDA2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(148, "SCL3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(149, "SDA3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(150, "SD0DAT0", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_2BIT,
			     136, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(151, "SD0DAT1", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_2BIT,
			     137, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(152, "SD0DAT2", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_2BIT,
			     138, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(153, "SD0DAT3", UNIPHIER_PIN_IECTRL_NONE,
			     15, UNIPHIER_PIN_DRV_2BIT,
			     139, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(154, "SD0CMD", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_2BIT,
			     141, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(155, "SD0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_2BIT,
			     140, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(156, "SD0CD", UNIPHIER_PIN_IECTRL_NONE,
			     142, UNIPHIER_PIN_DRV_1BIT,
			     142, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(157, "SD0WP", UNIPHIER_PIN_IECTRL_NONE,
			     143, UNIPHIER_PIN_DRV_1BIT,
			     143, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(158, "SD0VTCG", UNIPHIER_PIN_IECTRL_NONE,
			     144, UNIPHIER_PIN_DRV_1BIT,
			     144, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(159, "CK25O", UNIPHIER_PIN_IECTRL_NONE,
			     145, UNIPHIER_PIN_DRV_1BIT,
			     145, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(160, "RGMII_TXCLK", 6,
			     146, UNIPHIER_PIN_DRV_1BIT,
			     146, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(161, "RGMII_TXD0", 6,
			     147, UNIPHIER_PIN_DRV_1BIT,
			     147, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(162, "RGMII_TXD1", 6,
			     148, UNIPHIER_PIN_DRV_1BIT,
			     148, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(163, "RGMII_TXD2", 6,
			     149, UNIPHIER_PIN_DRV_1BIT,
			     149, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(164, "RGMII_TXD3", 6,
			     150, UNIPHIER_PIN_DRV_1BIT,
			     150, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(165, "RGMII_TXCTL", 6,
			     151, UNIPHIER_PIN_DRV_1BIT,
			     151, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(166, "MII_TXER", UNIPHIER_PIN_IECTRL_NONE,
			     152, UNIPHIER_PIN_DRV_1BIT,
			     152, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(167, "RGMII_RXCLK", 6,
			     153, UNIPHIER_PIN_DRV_1BIT,
			     153, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(168, "RGMII_RXD0", 6,
			     154, UNIPHIER_PIN_DRV_1BIT,
			     154, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(169, "RGMII_RXD1", 6,
			     155, UNIPHIER_PIN_DRV_1BIT,
			     155, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(170, "RGMII_RXD2", 6,
			     156, UNIPHIER_PIN_DRV_1BIT,
			     156, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(171, "RGMII_RXD3", 6,
			     157, UNIPHIER_PIN_DRV_1BIT,
			     157, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(172, "RGMII_RXCTL", 6,
			     158, UNIPHIER_PIN_DRV_1BIT,
			     158, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(173, "MII_RXER", 6,
			     159, UNIPHIER_PIN_DRV_1BIT,
			     159, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(174, "MII_CRS", 6,
			     160, UNIPHIER_PIN_DRV_1BIT,
			     160, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(175, "MII_COL", 6,
			     161, UNIPHIER_PIN_DRV_1BIT,
			     161, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(176, "MDC", 6,
			     162, UNIPHIER_PIN_DRV_1BIT,
			     162, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(177, "MDIO", 6,
			     163, UNIPHIER_PIN_DRV_1BIT,
			     163, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(178, "MDIO_INTL", 6,
			     164, UNIPHIER_PIN_DRV_1BIT,
			     164, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(179, "XETH_RST", 6,
			     165, UNIPHIER_PIN_DRV_1BIT,
			     165, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(180, "USB0VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     166, UNIPHIER_PIN_DRV_1BIT,
			     166, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(181, "USB0OD", UNIPHIER_PIN_IECTRL_NONE,
			     167, UNIPHIER_PIN_DRV_1BIT,
			     167, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(182, "USB1VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     168, UNIPHIER_PIN_DRV_1BIT,
			     168, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(183, "USB1OD", UNIPHIER_PIN_IECTRL_NONE,
			     169, UNIPHIER_PIN_DRV_1BIT,
			     169, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(184, "USB2VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     170, UNIPHIER_PIN_DRV_1BIT,
			     170, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(185, "USB2OD", UNIPHIER_PIN_IECTRL_NONE,
			     171, UNIPHIER_PIN_DRV_1BIT,
			     171, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(186, "USB2ID", UNIPHIER_PIN_IECTRL_NONE,
			     172, UNIPHIER_PIN_DRV_1BIT,
			     172, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(187, "USB3VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     173, UNIPHIER_PIN_DRV_1BIT,
			     173, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(188, "USB3OD", UNIPHIER_PIN_IECTRL_NONE,
			     174, UNIPHIER_PIN_DRV_1BIT,
			     174, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(189, "LINKCLK", UNIPHIER_PIN_IECTRL_NONE,
			     175, UNIPHIER_PIN_DRV_1BIT,
			     175, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(190, "LINKREQ", UNIPHIER_PIN_IECTRL_NONE,
			     176, UNIPHIER_PIN_DRV_1BIT,
			     176, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(191, "LINKCTL0", UNIPHIER_PIN_IECTRL_NONE,
			     177, UNIPHIER_PIN_DRV_1BIT,
			     177, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(192, "LINKCTL1", UNIPHIER_PIN_IECTRL_NONE,
			     178, UNIPHIER_PIN_DRV_1BIT,
			     178, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(193, "LINKDT0", UNIPHIER_PIN_IECTRL_NONE,
			     179, UNIPHIER_PIN_DRV_1BIT,
			     179, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(194, "LINKDT1", UNIPHIER_PIN_IECTRL_NONE,
			     180, UNIPHIER_PIN_DRV_1BIT,
			     180, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(195, "LINKDT2", UNIPHIER_PIN_IECTRL_NONE,
			     181, UNIPHIER_PIN_DRV_1BIT,
			     181, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(196, "LINKDT3", UNIPHIER_PIN_IECTRL_NONE,
			     182, UNIPHIER_PIN_DRV_1BIT,
			     182, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(197, "LINKDT4", UNIPHIER_PIN_IECTRL_NONE,
			     183, UNIPHIER_PIN_DRV_1BIT,
			     183, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(198, "LINKDT5", UNIPHIER_PIN_IECTRL_NONE,
			     184, UNIPHIER_PIN_DRV_1BIT,
			     184, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(199, "LINKDT6", UNIPHIER_PIN_IECTRL_NONE,
			     185, UNIPHIER_PIN_DRV_1BIT,
			     185, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(200, "LINKDT7", UNIPHIER_PIN_IECTRL_NONE,
			     186, UNIPHIER_PIN_DRV_1BIT,
			     186, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(201, "CKDVO", UNIPHIER_PIN_IECTRL_NONE,
			     187, UNIPHIER_PIN_DRV_1BIT,
			     187, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(202, "PHY_PD", UNIPHIER_PIN_IECTRL_NONE,
			     188, UNIPHIER_PIN_DRV_1BIT,
			     188, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(203, "X1394_RST", UNIPHIER_PIN_IECTRL_NONE,
			     189, UNIPHIER_PIN_DRV_1BIT,
			     189, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(204, "VOUT_MUTE_L", UNIPHIER_PIN_IECTRL_NONE,
			     190, UNIPHIER_PIN_DRV_1BIT,
			     190, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(205, "CLK54O", UNIPHIER_PIN_IECTRL_NONE,
			     191, UNIPHIER_PIN_DRV_1BIT,
			     191, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(206, "CLK54I", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_NONE,
			     192, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(207, "YIN0", UNIPHIER_PIN_IECTRL_NONE,
			     193, UNIPHIER_PIN_DRV_1BIT,
			     193, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(208, "YIN1", UNIPHIER_PIN_IECTRL_NONE,
			     194, UNIPHIER_PIN_DRV_1BIT,
			     194, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(209, "YIN2", UNIPHIER_PIN_IECTRL_NONE,
			     195, UNIPHIER_PIN_DRV_1BIT,
			     195, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(210, "YIN3", UNIPHIER_PIN_IECTRL_NONE,
			     196, UNIPHIER_PIN_DRV_1BIT,
			     196, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(211, "YIN4", UNIPHIER_PIN_IECTRL_NONE,
			     197, UNIPHIER_PIN_DRV_1BIT,
			     197, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(212, "YIN5", UNIPHIER_PIN_IECTRL_NONE,
			     198, UNIPHIER_PIN_DRV_1BIT,
			     198, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(213, "CIN0", UNIPHIER_PIN_IECTRL_NONE,
			     199, UNIPHIER_PIN_DRV_1BIT,
			     199, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(214, "CIN1", UNIPHIER_PIN_IECTRL_NONE,
			     200, UNIPHIER_PIN_DRV_1BIT,
			     200, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(215, "CIN2", UNIPHIER_PIN_IECTRL_NONE,
			     201, UNIPHIER_PIN_DRV_1BIT,
			     201, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(216, "CIN3", UNIPHIER_PIN_IECTRL_NONE,
			     202, UNIPHIER_PIN_DRV_1BIT,
			     202, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(217, "CIN4", UNIPHIER_PIN_IECTRL_NONE,
			     203, UNIPHIER_PIN_DRV_1BIT,
			     203, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(218, "CIN5", UNIPHIER_PIN_IECTRL_NONE,
			     204, UNIPHIER_PIN_DRV_1BIT,
			     204, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(219, "GCP", UNIPHIER_PIN_IECTRL_NONE,
			     205, UNIPHIER_PIN_DRV_1BIT,
			     205, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(220, "ADFLG", UNIPHIER_PIN_IECTRL_NONE,
			     206, UNIPHIER_PIN_DRV_1BIT,
			     206, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(221, "CK27AIOF", UNIPHIER_PIN_IECTRL_NONE,
			     207, UNIPHIER_PIN_DRV_1BIT,
			     207, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(222, "DACOUT", UNIPHIER_PIN_IECTRL_NONE,
			     208, UNIPHIER_PIN_DRV_1BIT,
			     208, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(223, "DAFLG", UNIPHIER_PIN_IECTRL_NONE,
			     209, UNIPHIER_PIN_DRV_1BIT,
			     209, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(224, "VBIH", UNIPHIER_PIN_IECTRL_NONE,
			     210, UNIPHIER_PIN_DRV_1BIT,
			     210, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(225, "VBIL", UNIPHIER_PIN_IECTRL_NONE,
			     211, UNIPHIER_PIN_DRV_1BIT,
			     211, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(226, "XSUB_RST", UNIPHIER_PIN_IECTRL_NONE,
			     212, UNIPHIER_PIN_DRV_1BIT,
			     212, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(227, "XADC_PD", UNIPHIER_PIN_IECTRL_NONE,
			     213, UNIPHIER_PIN_DRV_1BIT,
			     213, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(228, "AI1ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     214, UNIPHIER_PIN_DRV_1BIT,
			     214, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(229, "AI1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     215, UNIPHIER_PIN_DRV_1BIT,
			     215, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(230, "AI1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     216, UNIPHIER_PIN_DRV_1BIT,
			     216, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(231, "AI1DMIX", UNIPHIER_PIN_IECTRL_NONE,
			     217, UNIPHIER_PIN_DRV_1BIT,
			     217, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(232, "CK27HD", UNIPHIER_PIN_IECTRL_NONE,
			     218, UNIPHIER_PIN_DRV_1BIT,
			     218, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(233, "XHD_RST", UNIPHIER_PIN_IECTRL_NONE,
			     219, UNIPHIER_PIN_DRV_1BIT,
			     219, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(234, "INTHD", UNIPHIER_PIN_IECTRL_NONE,
			     220, UNIPHIER_PIN_DRV_1BIT,
			     220, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(235, "VO1HDCK", UNIPHIER_PIN_IECTRL_NONE,
			     221, UNIPHIER_PIN_DRV_1BIT,
			     221, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(236, "VO1HSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     222, UNIPHIER_PIN_DRV_1BIT,
			     222, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(237, "VO1VSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     223, UNIPHIER_PIN_DRV_1BIT,
			     223, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(238, "VO1DE", UNIPHIER_PIN_IECTRL_NONE,
			     224, UNIPHIER_PIN_DRV_1BIT,
			     224, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(239, "VO1Y0", UNIPHIER_PIN_IECTRL_NONE,
			     225, UNIPHIER_PIN_DRV_1BIT,
			     225, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(240, "VO1Y1", UNIPHIER_PIN_IECTRL_NONE,
			     226, UNIPHIER_PIN_DRV_1BIT,
			     226, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(241, "VO1Y2", UNIPHIER_PIN_IECTRL_NONE,
			     227, UNIPHIER_PIN_DRV_1BIT,
			     227, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(242, "VO1Y3", UNIPHIER_PIN_IECTRL_NONE,
			     228, UNIPHIER_PIN_DRV_1BIT,
			     228, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(243, "VO1Y4", UNIPHIER_PIN_IECTRL_NONE,
			     229, UNIPHIER_PIN_DRV_1BIT,
			     229, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(244, "VO1Y5", UNIPHIER_PIN_IECTRL_NONE,
			     230, UNIPHIER_PIN_DRV_1BIT,
			     230, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(245, "VO1Y6", UNIPHIER_PIN_IECTRL_NONE,
			     231, UNIPHIER_PIN_DRV_1BIT,
			     231, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(246, "VO1Y7", UNIPHIER_PIN_IECTRL_NONE,
			     232, UNIPHIER_PIN_DRV_1BIT,
			     232, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(247, "VO1Y8", UNIPHIER_PIN_IECTRL_NONE,
			     233, UNIPHIER_PIN_DRV_1BIT,
			     233, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(248, "VO1Y9", UNIPHIER_PIN_IECTRL_NONE,
			     234, UNIPHIER_PIN_DRV_1BIT,
			     234, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(249, "VO1Y10", UNIPHIER_PIN_IECTRL_NONE,
			     235, UNIPHIER_PIN_DRV_1BIT,
			     235, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(250, "VO1Y11", UNIPHIER_PIN_IECTRL_NONE,
			     236, UNIPHIER_PIN_DRV_1BIT,
			     236, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(251, "VO1CB0", UNIPHIER_PIN_IECTRL_NONE,
			     237, UNIPHIER_PIN_DRV_1BIT,
			     237, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(252, "VO1CB1", UNIPHIER_PIN_IECTRL_NONE,
			     238, UNIPHIER_PIN_DRV_1BIT,
			     238, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(253, "VO1CB2", UNIPHIER_PIN_IECTRL_NONE,
			     239, UNIPHIER_PIN_DRV_1BIT,
			     239, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(254, "VO1CB3", UNIPHIER_PIN_IECTRL_NONE,
			     240, UNIPHIER_PIN_DRV_1BIT,
			     240, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(255, "VO1CB4", UNIPHIER_PIN_IECTRL_NONE,
			     241, UNIPHIER_PIN_DRV_1BIT,
			     241, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(256, "VO1CB5", UNIPHIER_PIN_IECTRL_NONE,
			     242, UNIPHIER_PIN_DRV_1BIT,
			     242, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(257, "VO1CB6", UNIPHIER_PIN_IECTRL_NONE,
			     243, UNIPHIER_PIN_DRV_1BIT,
			     243, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(258, "VO1CB7", UNIPHIER_PIN_IECTRL_NONE,
			     244, UNIPHIER_PIN_DRV_1BIT,
			     244, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(259, "VO1CB8", UNIPHIER_PIN_IECTRL_NONE,
			     245, UNIPHIER_PIN_DRV_1BIT,
			     245, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(260, "VO1CB9", UNIPHIER_PIN_IECTRL_NONE,
			     246, UNIPHIER_PIN_DRV_1BIT,
			     246, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(261, "VO1CB10", UNIPHIER_PIN_IECTRL_NONE,
			     247, UNIPHIER_PIN_DRV_1BIT,
			     247, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(262, "VO1CB11", UNIPHIER_PIN_IECTRL_NONE,
			     248, UNIPHIER_PIN_DRV_1BIT,
			     248, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(263, "VO1CR0", UNIPHIER_PIN_IECTRL_NONE,
			     249, UNIPHIER_PIN_DRV_1BIT,
			     249, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(264, "VO1CR1", UNIPHIER_PIN_IECTRL_NONE,
			     250, UNIPHIER_PIN_DRV_1BIT,
			     250, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(265, "VO1CR2", UNIPHIER_PIN_IECTRL_NONE,
			     251, UNIPHIER_PIN_DRV_1BIT,
			     251, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(266, "VO1CR3", UNIPHIER_PIN_IECTRL_NONE,
			     252, UNIPHIER_PIN_DRV_1BIT,
			     252, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(267, "VO1CR4", UNIPHIER_PIN_IECTRL_NONE,
			     253, UNIPHIER_PIN_DRV_1BIT,
			     253, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(268, "VO1CR5", UNIPHIER_PIN_IECTRL_NONE,
			     254, UNIPHIER_PIN_DRV_1BIT,
			     254, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(269, "VO1CR6", UNIPHIER_PIN_IECTRL_NONE,
			     255, UNIPHIER_PIN_DRV_1BIT,
			     255, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(270, "VO1CR7", UNIPHIER_PIN_IECTRL_NONE,
			     256, UNIPHIER_PIN_DRV_1BIT,
			     256, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(271, "VO1CR8", UNIPHIER_PIN_IECTRL_NONE,
			     257, UNIPHIER_PIN_DRV_1BIT,
			     257, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(272, "VO1CR9", UNIPHIER_PIN_IECTRL_NONE,
			     258, UNIPHIER_PIN_DRV_1BIT,
			     258, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(273, "VO1CR10", UNIPHIER_PIN_IECTRL_NONE,
			     259, UNIPHIER_PIN_DRV_1BIT,
			     259, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(274, "VO1CR11", UNIPHIER_PIN_IECTRL_NONE,
			     260, UNIPHIER_PIN_DRV_1BIT,
			     260, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(275, "VO1EX0", UNIPHIER_PIN_IECTRL_NONE,
			     261, UNIPHIER_PIN_DRV_1BIT,
			     261, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(276, "VO1EX1", UNIPHIER_PIN_IECTRL_NONE,
			     262, UNIPHIER_PIN_DRV_1BIT,
			     262, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(277, "VO1EX2", UNIPHIER_PIN_IECTRL_NONE,
			     263, UNIPHIER_PIN_DRV_1BIT,
			     263, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(278, "VO1EX3", UNIPHIER_PIN_IECTRL_NONE,
			     264, UNIPHIER_PIN_DRV_1BIT,
			     264, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(279, "VEXCKA", UNIPHIER_PIN_IECTRL_NONE,
			     265, UNIPHIER_PIN_DRV_1BIT,
			     265, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(280, "VSEL0", UNIPHIER_PIN_IECTRL_NONE,
			     266, UNIPHIER_PIN_DRV_1BIT,
			     266, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(281, "VSEL1", UNIPHIER_PIN_IECTRL_NONE,
			     267, UNIPHIER_PIN_DRV_1BIT,
			     267, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(282, "AO1DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     268, UNIPHIER_PIN_DRV_1BIT,
			     268, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(283, "AO1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     269, UNIPHIER_PIN_DRV_1BIT,
			     269, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(284, "AO1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     270, UNIPHIER_PIN_DRV_1BIT,
			     270, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(285, "AO1D0", UNIPHIER_PIN_IECTRL_NONE,
			     271, UNIPHIER_PIN_DRV_1BIT,
			     271, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(286, "AO1D1", UNIPHIER_PIN_IECTRL_NONE,
			     272, UNIPHIER_PIN_DRV_1BIT,
			     272, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(287, "AO1D2", UNIPHIER_PIN_IECTRL_NONE,
			     273, UNIPHIER_PIN_DRV_1BIT,
			     273, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(288, "AO1D3", UNIPHIER_PIN_IECTRL_NONE,
			     274, UNIPHIER_PIN_DRV_1BIT,
			     274, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(289, "AO1IEC", UNIPHIER_PIN_IECTRL_NONE,
			     275, UNIPHIER_PIN_DRV_1BIT,
			     275, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(290, "XDAC_PD", UNIPHIER_PIN_IECTRL_NONE,
			     276, UNIPHIER_PIN_DRV_1BIT,
			     276, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(291, "EX_A_MUTE", UNIPHIER_PIN_IECTRL_NONE,
			     277, UNIPHIER_PIN_DRV_1BIT,
			     277, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(292, "AO2DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     278, UNIPHIER_PIN_DRV_1BIT,
			     278, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(293, "AO2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     279, UNIPHIER_PIN_DRV_1BIT,
			     279, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(294, "AO2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     280, UNIPHIER_PIN_DRV_1BIT,
			     280, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(295, "AO2DMIX", UNIPHIER_PIN_IECTRL_NONE,
			     281, UNIPHIER_PIN_DRV_1BIT,
			     281, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(296, "AO2IEC", UNIPHIER_PIN_IECTRL_NONE,
			     282, UNIPHIER_PIN_DRV_1BIT,
			     282, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(297, "HTHPD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED5,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(298, "HTSCL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED5,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(299, "HTSDA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED5,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(300, "PORT00", UNIPHIER_PIN_IECTRL_NONE,
			     284, UNIPHIER_PIN_DRV_1BIT,
			     284, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(301, "PORT01", UNIPHIER_PIN_IECTRL_NONE,
			     285, UNIPHIER_PIN_DRV_1BIT,
			     285, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(302, "PORT02", UNIPHIER_PIN_IECTRL_NONE,
			     286, UNIPHIER_PIN_DRV_1BIT,
			     286, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(303, "PORT03", UNIPHIER_PIN_IECTRL_NONE,
			     287, UNIPHIER_PIN_DRV_1BIT,
			     287, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(304, "PORT04", UNIPHIER_PIN_IECTRL_NONE,
			     288, UNIPHIER_PIN_DRV_1BIT,
			     288, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(305, "PORT05", UNIPHIER_PIN_IECTRL_NONE,
			     289, UNIPHIER_PIN_DRV_1BIT,
			     289, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(306, "PORT06", UNIPHIER_PIN_IECTRL_NONE,
			     290, UNIPHIER_PIN_DRV_1BIT,
			     290, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(307, "PORT07", UNIPHIER_PIN_IECTRL_NONE,
			     291, UNIPHIER_PIN_DRV_1BIT,
			     291, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(308, "PORT10", UNIPHIER_PIN_IECTRL_NONE,
			     292, UNIPHIER_PIN_DRV_1BIT,
			     292, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(309, "PORT11", UNIPHIER_PIN_IECTRL_NONE,
			     293, UNIPHIER_PIN_DRV_1BIT,
			     293, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(310, "PORT12", UNIPHIER_PIN_IECTRL_NONE,
			     294, UNIPHIER_PIN_DRV_1BIT,
			     294, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(311, "PORT13", UNIPHIER_PIN_IECTRL_NONE,
			     295, UNIPHIER_PIN_DRV_1BIT,
			     295, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(312, "PORT14", UNIPHIER_PIN_IECTRL_NONE,
			     296, UNIPHIER_PIN_DRV_1BIT,
			     296, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(313, "PORT15", UNIPHIER_PIN_IECTRL_NONE,
			     297, UNIPHIER_PIN_DRV_1BIT,
			     297, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(314, "PORT16", UNIPHIER_PIN_IECTRL_NONE,
			     298, UNIPHIER_PIN_DRV_1BIT,
			     298, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(315, "PORT17", UNIPHIER_PIN_IECTRL_NONE,
			     299, UNIPHIER_PIN_DRV_1BIT,
			     299, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(316, "PORT20", UNIPHIER_PIN_IECTRL_NONE,
			     300, UNIPHIER_PIN_DRV_1BIT,
			     300, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(317, "PORT21", UNIPHIER_PIN_IECTRL_NONE,
			     301, UNIPHIER_PIN_DRV_1BIT,
			     301, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(318, "PORT22", UNIPHIER_PIN_IECTRL_NONE,
			     302, UNIPHIER_PIN_DRV_1BIT,
			     302, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(319, "SD1DAT0", UNIPHIER_PIN_IECTRL_NONE,
			     303, UNIPHIER_PIN_DRV_1BIT,
			     303, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(320, "SD1DAT1", UNIPHIER_PIN_IECTRL_NONE,
			     304, UNIPHIER_PIN_DRV_1BIT,
			     304, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(321, "SD1DAT2", UNIPHIER_PIN_IECTRL_NONE,
			     305, UNIPHIER_PIN_DRV_1BIT,
			     305, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(322, "SD1DAT3", UNIPHIER_PIN_IECTRL_NONE,
			     306, UNIPHIER_PIN_DRV_1BIT,
			     306, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(323, "SD1CMD", UNIPHIER_PIN_IECTRL_NONE,
			     307, UNIPHIER_PIN_DRV_1BIT,
			     307, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(324, "SD1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     308, UNIPHIER_PIN_DRV_1BIT,
			     308, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(325, "SD1CD", UNIPHIER_PIN_IECTRL_NONE,
			     309, UNIPHIER_PIN_DRV_1BIT,
			     309, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(326, "SD1WP", UNIPHIER_PIN_IECTRL_NONE,
			     310, UNIPHIER_PIN_DRV_1BIT,
			     310, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(327, "SD1VTCG", UNIPHIER_PIN_IECTRL_NONE,
			     311, UNIPHIER_PIN_DRV_1BIT,
			     311, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(328, "DMDISO", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_NONE,
			     312, UNIPHIER_PIN_PULL_DOWN),
};

static const unsigned emmc_pins[] = {40, 41, 42, 43, 51, 52, 53};
static const int emmc_muxvals[] = {1, 1, 1, 1, 1, 1, 1};
static const unsigned emmc_dat8_pins[] = {44, 45, 46, 47};
static const int emmc_dat8_muxvals[] = {1, 1, 1, 1};
static const unsigned ether_mii_pins[] = {160, 161, 162, 163, 164, 165, 166,
					  167, 168, 169, 170, 171, 172, 173,
					  174, 175, 176, 177, 178, 179};
static const int ether_mii_muxvals[] = {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0};
static const unsigned ether_rgmii_pins[] = {160, 161, 162, 163, 164, 165, 167,
					    168, 169, 170, 171, 172, 176, 177,
					    178, 179};
static const int ether_rgmii_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					  0, 0, 0, 0};
static const unsigned ether_rmii_pins[] = {160, 161, 162, 165, 168, 169, 172,
					   173, 176, 177, 178, 179};
static const int ether_rmii_muxvals[] = {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned ether_rmiib_pins[] = {161, 162, 165, 167, 168, 169, 172,
					    173, 176, 177, 178, 179};
static const int ether_rmiib_muxvals[] = {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned i2c0_pins[] = {142, 143};
static const int i2c0_muxvals[] = {0, 0};
static const unsigned i2c1_pins[] = {144, 145};
static const int i2c1_muxvals[] = {0, 0};
static const unsigned i2c2_pins[] = {146, 147};
static const int i2c2_muxvals[] = {0, 0};
static const unsigned i2c3_pins[] = {148, 149};
static const int i2c3_muxvals[] = {0, 0};
static const unsigned i2c6_pins[] = {308, 309};
static const int i2c6_muxvals[] = {6, 6};
static const unsigned nand_pins[] = {40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
				     50, 51, 52, 53, 54};
static const int nand_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned nand_cs1_pins[] = {131, 132};
static const int nand_cs1_muxvals[] = {1, 1};
static const unsigned sd_pins[] = {150, 151, 152, 153, 154, 155, 156, 157, 158};
static const int sd_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned sd1_pins[] = {319, 320, 321, 322, 323, 324, 325, 326,
				    327};
static const int sd1_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned system_bus_pins[] = {25, 26, 27, 28, 29, 30, 31, 32, 33,
					   34, 35, 36, 37, 38};
static const int system_bus_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					 0};
static const unsigned system_bus_cs0_pins[] = {318};
static const int system_bus_cs0_muxvals[] = {5};
static const unsigned system_bus_cs1_pins[] = {24};
static const int system_bus_cs1_muxvals[] = {0};
static const unsigned system_bus_cs2_pins[] = {315};
static const int system_bus_cs2_muxvals[] = {5};
static const unsigned system_bus_cs3_pins[] = {313};
static const int system_bus_cs3_muxvals[] = {5};
static const unsigned system_bus_cs4_pins[] = {305};
static const int system_bus_cs4_muxvals[] = {5};
static const unsigned system_bus_cs5_pins[] = {303};
static const int system_bus_cs5_muxvals[] = {6};
static const unsigned system_bus_cs6_pins[] = {307};
static const int system_bus_cs6_muxvals[] = {6};
static const unsigned system_bus_cs7_pins[] = {312};
static const int system_bus_cs7_muxvals[] = {6};
static const unsigned uart0_pins[] = {127, 128};
static const int uart0_muxvals[] = {0, 0};
static const unsigned uart1_pins[] = {129, 130};
static const int uart1_muxvals[] = {0, 0};
static const unsigned uart2_pins[] = {131, 132};
static const int uart2_muxvals[] = {0, 0};
static const unsigned uart3_pins[] = {88, 89};
static const int uart3_muxvals[] = {2, 2};
static const unsigned usb0_pins[] = {180, 181};
static const int usb0_muxvals[] = {0, 0};
static const unsigned usb1_pins[] = {182, 183};
static const int usb1_muxvals[] = {0, 0};
static const unsigned usb2_pins[] = {184, 185};
static const int usb2_muxvals[] = {0, 0};
static const unsigned usb3_pins[] = {187, 188};
static const int usb3_muxvals[] = {0, 0};
static const unsigned port_range0_pins[] = {
	300, 301, 302, 303, 304, 305, 306, 307,		/* PORT0x */
	308, 309, 310, 311, 312, 313, 314, 315,		/* PORT1x */
	316, 317, 318, 16, 17, 18, 19, 20,		/* PORT2x */
	21, 22, 23, 4, 93, 94, 95, 63,			/* PORT3x */
	123, 122, 124, 125, 126, 141, 202, 203,		/* PORT4x */
	204, 226, 227, 290, 291, 233, 280, 281,		/* PORT5x */
	8, 7, 10, 29, 30, 48, 49, 50,			/* PORT6x */
	40, 41, 42, 43, 44, 45, 46, 47,			/* PORT7x */
	54, 51, 52, 53, 127, 128, 129, 130,		/* PORT8x */
	131, 132, 57, 60, 134, 133, 135, 136,		/* PORT9x */
	138, 137, 140, 139, 64, 65, 66, 67,		/* PORT10x */
	107, 106, 105, 104, 113, 112, 111, 110,		/* PORT11x */
	68, 69, 70, 71, 72, 73, 74, 75,			/* PORT12x */
	76, 77, 78, 79, 80, 81, 82, 83,			/* PORT13x */
	84, 85, 86, 87, 88, 89, 90, 91,			/* PORT14x */
};
static const int port_range0_muxvals[] = {
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT0x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT1x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT2x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT3x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT4x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT5x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT6x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT7x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT8x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT9x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT10x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT11x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT12x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT13x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT14x */
};
static const unsigned port_range1_pins[] = {
	13, 14, 15,					/* PORT175-177 */
	157, 158, 156, 154, 150, 151, 152, 153,		/* PORT18x */
	326, 327, 325, 323, 319, 320, 321, 322,		/* PORT19x */
	160, 161, 162, 163, 164, 165, 166, 167,		/* PORT20x */
	168, 169, 170, 171, 172, 173, 174, 175,		/* PORT21x */
	180, 181, 182, 183, 184, 185, 187, 188,		/* PORT22x */
	193, 194, 195, 196, 197, 198, 199, 200,		/* PORT23x */
	191, 192, 215, 216, 217, 218, 219, 220,		/* PORT24x */
	222, 223, 224, 225, 228, 229, 230, 231,		/* PORT25x */
	282, 283, 284, 285, 286, 287, 288, 289,		/* PORT26x */
	292, 293, 294, 295, 296, 236, 237, 238,		/* PORT27x */
	275, 276, 277, 278, 239, 240, 249, 250,		/* PORT28x */
	251, 252, 261, 262, 263, 264, 273, 274,		/* PORT29x */
	31, 32, 33, 34, 35, 36, 37, 38,			/* PORT30x */
};
static const int port_range1_muxvals[] = {
	7, 7, 7,					/* PORT175-177 */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT18x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT19x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT20x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT21x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT22x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT23x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT24x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT25x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT26x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT27x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT28x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT29x */
	7, 7, 7, 7, 7, 7, 7, 7,				/* PORT30x */
};
static const unsigned xirq_pins[] = {
	11, 9, 12, 96, 97, 98, 108, 114,		/* XIRQ0-7 */
	234, 186, 99, 100, 101, 102, 184, 301,		/* XIRQ8-15 */
	302, 303, 304, 305, 306,			/* XIRQ16-20 */
};
static const int xirq_muxvals[] = {
	7, 7, 7, 7, 7, 7, 7, 7,				/* XIRQ0-7 */
	7, 7, 7, 7, 7, 7, 2, 2,				/* XIRQ8-15 */
	2, 2, 2, 2, 2,					/* XIRQ16-20 */
};
static const unsigned xirq_alternatives_pins[] = {
	184, 310, 316,
};
static const int xirq_alternatives_muxvals[] = {
	2, 2, 2,
};

static const struct uniphier_pinctrl_group uniphier_pro4_groups[] = {
	UNIPHIER_PINCTRL_GROUP(emmc),
	UNIPHIER_PINCTRL_GROUP(emmc_dat8),
	UNIPHIER_PINCTRL_GROUP(ether_mii),
	UNIPHIER_PINCTRL_GROUP(ether_rgmii),
	UNIPHIER_PINCTRL_GROUP(ether_rmii),
	UNIPHIER_PINCTRL_GROUP(ether_rmiib),
	UNIPHIER_PINCTRL_GROUP(i2c0),
	UNIPHIER_PINCTRL_GROUP(i2c1),
	UNIPHIER_PINCTRL_GROUP(i2c2),
	UNIPHIER_PINCTRL_GROUP(i2c3),
	UNIPHIER_PINCTRL_GROUP(i2c6),
	UNIPHIER_PINCTRL_GROUP(nand),
	UNIPHIER_PINCTRL_GROUP(nand_cs1),
	UNIPHIER_PINCTRL_GROUP(sd),
	UNIPHIER_PINCTRL_GROUP(sd1),
	UNIPHIER_PINCTRL_GROUP(system_bus),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs0),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs1),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs2),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs3),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs4),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs5),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs6),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs7),
	UNIPHIER_PINCTRL_GROUP(uart0),
	UNIPHIER_PINCTRL_GROUP(uart1),
	UNIPHIER_PINCTRL_GROUP(uart2),
	UNIPHIER_PINCTRL_GROUP(uart3),
	UNIPHIER_PINCTRL_GROUP(usb0),
	UNIPHIER_PINCTRL_GROUP(usb1),
	UNIPHIER_PINCTRL_GROUP(usb2),
	UNIPHIER_PINCTRL_GROUP(usb3),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range0),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range1),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_IRQ(xirq),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_IRQ(xirq_alternatives),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port00, port_range0, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port01, port_range0, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port02, port_range0, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port03, port_range0, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port04, port_range0, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port05, port_range0, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port06, port_range0, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port07, port_range0, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port10, port_range0, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port11, port_range0, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port12, port_range0, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port13, port_range0, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port14, port_range0, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port15, port_range0, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port16, port_range0, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port17, port_range0, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port20, port_range0, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port21, port_range0, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port22, port_range0, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port23, port_range0, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port24, port_range0, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port25, port_range0, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port26, port_range0, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port27, port_range0, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port30, port_range0, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port31, port_range0, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port32, port_range0, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port33, port_range0, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port34, port_range0, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port35, port_range0, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port36, port_range0, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port37, port_range0, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port40, port_range0, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port41, port_range0, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port42, port_range0, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port43, port_range0, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port44, port_range0, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port45, port_range0, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port46, port_range0, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port47, port_range0, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port50, port_range0, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port51, port_range0, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port52, port_range0, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port53, port_range0, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port54, port_range0, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port55, port_range0, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port56, port_range0, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port57, port_range0, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port60, port_range0, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port61, port_range0, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port62, port_range0, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port63, port_range0, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port64, port_range0, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port65, port_range0, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port66, port_range0, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port67, port_range0, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port70, port_range0, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port71, port_range0, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port72, port_range0, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port73, port_range0, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port74, port_range0, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port75, port_range0, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port76, port_range0, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port77, port_range0, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port80, port_range0, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port81, port_range0, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port82, port_range0, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port83, port_range0, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port84, port_range0, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port85, port_range0, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port86, port_range0, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port87, port_range0, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port90, port_range0, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port91, port_range0, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port92, port_range0, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port93, port_range0, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port94, port_range0, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port95, port_range0, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port96, port_range0, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port97, port_range0, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port100, port_range0, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port101, port_range0, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port102, port_range0, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port103, port_range0, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port104, port_range0, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port105, port_range0, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port106, port_range0, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port107, port_range0, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port110, port_range0, 88),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port111, port_range0, 89),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port112, port_range0, 90),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port113, port_range0, 91),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port114, port_range0, 92),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port115, port_range0, 93),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port116, port_range0, 94),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port117, port_range0, 95),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port120, port_range0, 96),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port121, port_range0, 97),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port122, port_range0, 98),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port123, port_range0, 99),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port124, port_range0, 100),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port125, port_range0, 101),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port126, port_range0, 102),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port127, port_range0, 103),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port130, port_range0, 104),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port131, port_range0, 105),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port132, port_range0, 106),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port133, port_range0, 107),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port134, port_range0, 108),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port135, port_range0, 109),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port136, port_range0, 110),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port137, port_range0, 111),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port140, port_range0, 112),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port141, port_range0, 113),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port142, port_range0, 114),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port143, port_range0, 115),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port144, port_range0, 116),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port145, port_range0, 117),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port146, port_range0, 118),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port147, port_range0, 119),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port175, port_range1, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port176, port_range1, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port177, port_range1, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port180, port_range1, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port181, port_range1, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port182, port_range1, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port183, port_range1, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port184, port_range1, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port185, port_range1, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port186, port_range1, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port187, port_range1, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port190, port_range1, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port191, port_range1, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port192, port_range1, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port193, port_range1, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port194, port_range1, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port195, port_range1, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port196, port_range1, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port197, port_range1, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port200, port_range1, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port201, port_range1, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port202, port_range1, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port203, port_range1, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port204, port_range1, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port205, port_range1, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port206, port_range1, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port207, port_range1, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port210, port_range1, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port211, port_range1, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port212, port_range1, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port213, port_range1, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port214, port_range1, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port215, port_range1, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port216, port_range1, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port217, port_range1, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port220, port_range1, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port221, port_range1, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port222, port_range1, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port223, port_range1, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port224, port_range1, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port225, port_range1, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port226, port_range1, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port227, port_range1, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port230, port_range1, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port231, port_range1, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port232, port_range1, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port233, port_range1, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port234, port_range1, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port235, port_range1, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port236, port_range1, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port237, port_range1, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port240, port_range1, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port241, port_range1, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port242, port_range1, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port243, port_range1, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port244, port_range1, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port245, port_range1, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port246, port_range1, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port247, port_range1, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port250, port_range1, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port251, port_range1, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port252, port_range1, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port253, port_range1, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port254, port_range1, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port255, port_range1, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port256, port_range1, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port257, port_range1, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port260, port_range1, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port261, port_range1, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port262, port_range1, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port263, port_range1, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port264, port_range1, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port265, port_range1, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port266, port_range1, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port267, port_range1, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port270, port_range1, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port271, port_range1, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port272, port_range1, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port273, port_range1, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port274, port_range1, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port275, port_range1, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port276, port_range1, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port277, port_range1, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port280, port_range1, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port281, port_range1, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port282, port_range1, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port283, port_range1, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port284, port_range1, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port285, port_range1, 88),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port286, port_range1, 89),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port287, port_range1, 90),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port290, port_range1, 91),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port291, port_range1, 92),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port292, port_range1, 93),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port293, port_range1, 94),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port294, port_range1, 95),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port295, port_range1, 96),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port296, port_range1, 97),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port297, port_range1, 98),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port300, port_range1, 99),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port301, port_range1, 100),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port302, port_range1, 101),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port303, port_range1, 102),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port304, port_range1, 103),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port305, port_range1, 104),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port306, port_range1, 105),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port307, port_range1, 106),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq0, xirq, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq1, xirq, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq2, xirq, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq3, xirq, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq4, xirq, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq5, xirq, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq6, xirq, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq7, xirq, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq8, xirq, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq9, xirq, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq10, xirq, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq11, xirq, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq12, xirq, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq13, xirq, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq14, xirq, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq15, xirq, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq16, xirq, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17, xirq, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18, xirq, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq19, xirq, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq20, xirq, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq14b, xirq_alternatives, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17b, xirq_alternatives, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18b, xirq_alternatives, 2),
};

static const char * const emmc_groups[] = {"emmc", "emmc_dat8"};
static const char * const ether_mii_groups[] = {"ether_mii"};
static const char * const ether_rgmii_groups[] = {"ether_rgmii"};
static const char * const ether_rmii_groups[] = {"ether_rgmii", "ether_rgmiib"};
static const char * const i2c0_groups[] = {"i2c0"};
static const char * const i2c1_groups[] = {"i2c1"};
static const char * const i2c2_groups[] = {"i2c2"};
static const char * const i2c3_groups[] = {"i2c3"};
static const char * const i2c6_groups[] = {"i2c6"};
static const char * const nand_groups[] = {"nand", "nand_cs1"};
static const char * const sd_groups[] = {"sd"};
static const char * const sd1_groups[] = {"sd1"};
static const char * const system_bus_groups[] = {"system_bus",
						 "system_bus_cs0",
						 "system_bus_cs1",
						 "system_bus_cs2",
						 "system_bus_cs3",
						 "system_bus_cs4",
						 "system_bus_cs5",
						 "system_bus_cs6",
						 "system_bus_cs7"};
static const char * const uart0_groups[] = {"uart0"};
static const char * const uart1_groups[] = {"uart1"};
static const char * const uart2_groups[] = {"uart2"};
static const char * const uart3_groups[] = {"uart3"};
static const char * const usb0_groups[] = {"usb0"};
static const char * const usb1_groups[] = {"usb1"};
static const char * const usb2_groups[] = {"usb2"};
static const char * const usb3_groups[] = {"usb3"};
static const char * const port_groups[] = {
	"port00",  "port01",  "port02",  "port03",
	"port04",  "port05",  "port06",  "port07",
	"port10",  "port11",  "port12",  "port13",
	"port14",  "port15",  "port16",  "port17",
	"port20",  "port21",  "port22",  "port23",
	"port24",  "port25",  "port26",  "port27",
	"port30",  "port31",  "port32",  "port33",
	"port34",  "port35",  "port36",  "port37",
	"port40",  "port41",  "port42",  "port43",
	"port44",  "port45",  "port46",  "port47",
	"port50",  "port51",  "port52",  "port53",
	"port54",  "port55",  "port56",  "port57",
	"port60",  "port61",  "port62",  "port63",
	"port64",  "port65",  "port66",  "port67",
	"port70",  "port71",  "port72",  "port73",
	"port74",  "port75",  "port76",  "port77",
	"port80",  "port81",  "port82",  "port83",
	"port84",  "port85",  "port86",  "port87",
	"port90",  "port91",  "port92",  "port93",
	"port94",  "port95",  "port96",  "port97",
	"port100", "port101", "port102", "port103",
	"port104", "port105", "port106", "port107",
	"port110", "port111", "port112", "port113",
	"port114", "port115", "port116", "port117",
	"port120", "port121", "port122", "port123",
	"port124", "port125", "port126", "port127",
	"port130", "port131", "port132", "port133",
	"port134", "port135", "port136", "port137",
	"port140", "port141", "port142", "port143",
	"port144", "port145", "port146", "port147",
	/* port150-174 missing */
	/* none */ "port175", "port176", "port177",
	"port180", "port181", "port182", "port183",
	"port184", "port185", "port186", "port187",
	"port190", "port191", "port192", "port193",
	"port194", "port195", "port196", "port197",
	"port200", "port201", "port202", "port203",
	"port204", "port205", "port206", "port207",
	"port210", "port211", "port212", "port213",
	"port214", "port215", "port216", "port217",
	"port220", "port221", "port222", "port223",
	"port224", "port225", "port226", "port227",
	"port230", "port231", "port232", "port233",
	"port234", "port235", "port236", "port237",
	"port240", "port241", "port242", "port243",
	"port244", "port245", "port246", "port247",
	"port250", "port251", "port252", "port253",
	"port254", "port255", "port256", "port257",
	"port260", "port261", "port262", "port263",
	"port264", "port265", "port266", "port267",
	"port270", "port271", "port272", "port273",
	"port274", "port275", "port276", "port277",
	"port280", "port281", "port282", "port283",
	"port284", "port285", "port286", "port287",
	"port290", "port291", "port292", "port293",
	"port294", "port295", "port296", "port297",
	"port300", "port301", "port302", "port303",
	"port304", "port305", "port306", "port307",
};
static const char * const xirq_groups[] = {
	"xirq0",  "xirq1",  "xirq2",  "xirq3",
	"xirq4",  "xirq5",  "xirq6",  "xirq7",
	"xirq8",  "xirq9",  "xirq10", "xirq11",
	"xirq12", "xirq13", "xirq14", "xirq15",
	"xirq16", "xirq17", "xirq18", "xirq19",
	"xirq20",
	"xirq14b", "xirq17b", "xirq18b",
};

static const struct uniphier_pinmux_function uniphier_pro4_functions[] = {
	UNIPHIER_PINMUX_FUNCTION(emmc),
	UNIPHIER_PINMUX_FUNCTION(ether_mii),
	UNIPHIER_PINMUX_FUNCTION(ether_rgmii),
	UNIPHIER_PINMUX_FUNCTION(ether_rmii),
	UNIPHIER_PINMUX_FUNCTION(i2c0),
	UNIPHIER_PINMUX_FUNCTION(i2c1),
	UNIPHIER_PINMUX_FUNCTION(i2c2),
	UNIPHIER_PINMUX_FUNCTION(i2c3),
	UNIPHIER_PINMUX_FUNCTION(i2c6),
	UNIPHIER_PINMUX_FUNCTION(nand),
	UNIPHIER_PINMUX_FUNCTION(sd),
	UNIPHIER_PINMUX_FUNCTION(sd1),
	UNIPHIER_PINMUX_FUNCTION(system_bus),
	UNIPHIER_PINMUX_FUNCTION(uart0),
	UNIPHIER_PINMUX_FUNCTION(uart1),
	UNIPHIER_PINMUX_FUNCTION(uart2),
	UNIPHIER_PINMUX_FUNCTION(uart3),
	UNIPHIER_PINMUX_FUNCTION(usb0),
	UNIPHIER_PINMUX_FUNCTION(usb1),
	UNIPHIER_PINMUX_FUNCTION(usb2),
	UNIPHIER_PINMUX_FUNCTION(usb3),
	UNIPHIER_PINMUX_FUNCTION(port),
	UNIPHIER_PINMUX_FUNCTION(xirq),
};

static struct uniphier_pinctrl_socdata uniphier_pro4_pindata = {
	.pins = uniphier_pro4_pins,
	.npins = ARRAY_SIZE(uniphier_pro4_pins),
	.groups = uniphier_pro4_groups,
	.groups_count = ARRAY_SIZE(uniphier_pro4_groups),
	.functions = uniphier_pro4_functions,
	.functions_count = ARRAY_SIZE(uniphier_pro4_functions),
	.caps = UNIPHIER_PINCTRL_CAPS_DBGMUX_SEPARATE,
};

static int uniphier_pro4_pinctrl_probe(struct platform_device *pdev)
{
	return uniphier_pinctrl_probe(pdev, &uniphier_pro4_pindata);
}

static const struct of_device_id uniphier_pro4_pinctrl_match[] = {
	{ .compatible = "socionext,uniphier-pro4-pinctrl" },
	{ /* sentinel */ }
};

static struct platform_driver uniphier_pro4_pinctrl_driver = {
	.probe = uniphier_pro4_pinctrl_probe,
	.driver = {
		.name = "uniphier-pro4-pinctrl",
		.of_match_table = uniphier_pro4_pinctrl_match,
	},
};
builtin_platform_driver(uniphier_pro4_pinctrl_driver);
