package ONVIF::Media::Types::VideoResolution;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Width_of :ATTR(:get<Width>);
my %Height_of :ATTR(:get<Height>);

__PACKAGE__->_factory(
    [ qw(        Width
        Height

    ) ],
    {
        'Width' => \%Width_of,
        'Height' => \%Height_of,
    },
    {
        'Width' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Height' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'Width' => 'Width',
        'Height' => 'Height',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::VideoResolution

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoResolution from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Width


=item * Height




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::VideoResolution
   Width =>  $some_value, # int
   Height =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

