package WSDiscovery10::Types::ResolveMatchType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://schemas.xmlsoap.org/ws/2005/04/discovery' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %EndpointReference_of :ATTR(:get<EndpointReference>);
my %Types_of :ATTR(:get<Types>);
my %Scopes_of :ATTR(:get<Scopes>);
my %XAddrs_of :ATTR(:get<XAddrs>);
my %MetadataVersion_of :ATTR(:get<MetadataVersion>);

__PACKAGE__->_factory(
    [ qw(        EndpointReference
        Types
        Scopes
        XAddrs
        MetadataVersion

    ) ],
    {
        'EndpointReference' => \%EndpointReference_of,
        'Types' => \%Types_of,
        'Scopes' => \%Scopes_of,
        'XAddrs' => \%XAddrs_of,
        'MetadataVersion' => \%MetadataVersion_of,
    },
    {
        'EndpointReference' => 'WSDiscovery10::Elements::EndpointReference',

        'Types' => 'WSDiscovery10::Elements::Types',

        'Scopes' => 'WSDiscovery10::Elements::Scopes',

        'XAddrs' => 'WSDiscovery10::Elements::XAddrs',

        'MetadataVersion' => 'WSDiscovery10::Elements::MetadataVersion',

    },
    {

        'EndpointReference' => '',
        'Types' => '',
        'Scopes' => '',
        'XAddrs' => '',
        'MetadataVersion' => '',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

WSDiscovery10::Types::ResolveMatchType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ResolveMatchType from the namespace http://schemas.xmlsoap.org/ws/2005/04/discovery.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EndpointReference

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * Types

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * Scopes

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * XAddrs

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * MetadataVersion

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSDiscovery10::Types::ResolveMatchType
   EndpointReference =>  { # WSDiscovery10::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceProperties =>  { # WSDiscovery10::Types::ReferencePropertiesType
     },
     ReferenceParameters =>  { # WSDiscovery10::Types::ReferenceParametersType
     },
     PortType =>  { value => $some_value },
     ServiceName =>  { value => $some_value },
   },
   Types => $some_value, # QNameListType
   Scopes =>  { value => $some_value },
   XAddrs => $some_value, # UriListType
   MetadataVersion =>  $some_value, # unsignedInt
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

