package ONVIF::PTZ::Types::DisplayCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %XAddr_of :ATTR(:get<XAddr>);
my %FixedLayout_of :ATTR(:get<FixedLayout>);

__PACKAGE__->_factory(
    [ qw(        XAddr
        FixedLayout

    ) ],
    {
        'XAddr' => \%XAddr_of,
        'FixedLayout' => \%FixedLayout_of,
    },
    {
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'FixedLayout' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'XAddr' => 'XAddr',
        'FixedLayout' => 'FixedLayout',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::DisplayCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DisplayCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * XAddr


=item * FixedLayout




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::DisplayCapabilities
   XAddr =>  $some_value, # anyURI
   FixedLayout =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

