/*
  license GPL v3 ...........

  description of this file:
  a page for viewing a user selected RSS feed ;

*/

import QtQuick 2.3
import QtQuick.XmlListModel 2.0
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0
import "./dateutils.js" as DateUtils
import "databasemodule_v2.js" as DB

Page {
    id: pageRoot
    objectName: "rssfeedpage"

    property alias articleView: innerArticleView

    function setFeed(model, index) {
        innerArticleView.setFeed(model, index)
        title = innerArticleView.feedTitle
    }

    ArticleViewItem {
        id: innerArticleView

        anchors.fill: parent
    }

    Component {
        id: readingOptionsPopoverComponent
        ReadingOptions { }
    } // Comp

    head.actions: [

        Action {
            text:  innerArticleView.modelItem == null ? "" : (innerArticleView.modelItem.favourite == "0" ? i18n.tr("Save") : i18n.tr("Remove"))
            iconSource: {
                if (innerArticleView.modelItem == null || innerArticleView.modelItem.favourite == "0")
                    return Qt.resolvedUrl("./icons_tmp/favorite-unselected.svg")
                else return Qt.resolvedUrl("./icons_tmp/favorite-selected.svg")
            }
            onTriggered: {
                var fav = (innerArticleView.modelItem.favourite == "0" ? "1" : "0")
                var dbResult = DB.updateArticleFavourite(innerArticleView.modelItem.id, fav)
                if (dbResult.rowsAffected === 1) {
                    innerArticleView.articleFavouriteChanged(innerArticleView.modelItem, fav)
                }
            }
        },

        Action {
            text:  i18n.tr("Options")
            iconSource: "./icons_tmp/settings.svg"
            onTriggered: {
                PopupUtils.open(readingOptionsPopoverComponent, null)
            }
        },

        Action {
            text:  i18n.tr("Open site")
            iconSource: Qt.resolvedUrl("./icons_tmp/go-to.svg")
            onTriggered: {
                Qt.openUrlExternally(innerArticleView.modelItem.link)
            }
        }
    ]
}


