import QtQuick 2.3
import QtQuick.XmlListModel 2.0

import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItems
import Ubuntu.Components.Popups 1.0

import "databasemodule_v2.js" as DB
import "dateutils.js" as DateUtils

Item {
    id: pageItself

    property int topicId: 0
    property var listViewModel: null
    property bool isShorts: topicId == 0

    // property var listTools: listModeTools

    function getListToots() {
        return listModeTools
    }

    function reload() {
        listViewModel = getModel()
    }

    function clear() {
        listViewModel = null
    }

    function showArticle(modelIndex) {
        listArticleView.setFeed(listViewModel, modelIndex)
    }

    Component {
        id: listModeDelegate

        Item {
            id: readIndicator

            anchors {
                left: parent.left
                right: parent.right
            }
            height: units.gu(14)

            UbuntuShape {
                id: listItem
                objectName: "feedlistitems"

                property bool useNoImageIcon: (pic.width == 0 || model.image == null || model.image == "")

                color: model.status == "1" ? Qt.rgba(0, 0, 0, 0.7) : Qt.rgba(0, 0, 0, 0.4)
                radius: "medium"
                anchors {
                    fill: parent
                    leftMargin: units.gu(2)
                    rightMargin: units.gu(2)
                    topMargin: units.gu(1)
                    bottomMargin: units.gu(1)
                }

                Item {
                    id: shapeClipper
                    height: parent.height
                    width: uPic.width > (listItem.width * 0.75) ? (listItem.width * 0.70) : (uPic.width == 0 ? units.gu(1) : (uPic.width - units.gu(1.5)))
                    clip: true

                    UbuntuShape {
                        id: uPic

                        height: parent.height
                        width: pic.width
                        radius: "medium"

                        image: Image {
                            id: pic
                            height: {
                                if (implicitHeight < 50 || implicitWidth < 50)
                                    return 0
                                else return uPic.height

                            }
                            width: height
                            source: selectIcon()
                            sourceSize.width: uPic.height * 2

                            function selectIcon() {
                                var img = model.image
                                return (model.image == null || model.image == "" ) ? /*Qt.resolvedUrl("rssreader64.png")*/ "" : model.image
                            }
                        }
                    }
                } // Item shapeClipper

                ActivityIndicator {
                    id: loadingIndicator
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: listItem.height / 3
                    running: pic.status == Image.Loading
                    visible: running
                }

                /* Ubuntu logo for articles without an image.
                 */
                Image {
                    anchors.centerIn: loadingIndicator
                    visible: listItem.useNoImageIcon && !loadingIndicator.running
                    source: Qt.resolvedUrl("icons_tmp/dash-home.svg")
                    width: units.gu(6)
                    height: width
                }

                Column {
                    id: content

                    anchors {
                        fill: parent; topMargin: units.gu(1.5); bottomMargin: units.gu(1.5);
                        leftMargin: listItem.height + units.gu(0.5); rightMargin: units.gu(1.5)
                    }
                    spacing: units.gu(1)

                    Row {
                        anchors {
                            left: parent.left
                            right: parent.right
                        }
                        height: labelTime.paintedHeight
                        spacing: units.gu(0.5)

                        Image {
                            id: imgFavourite
                            anchors.verticalCenter: labelTime.verticalCenter
                            fillMode: Image.PreserveAspectCrop
                            source: Qt.resolvedUrl("icons_tmp/favorite-selected.svg")
                            sourceSize.height: model.favourite == "1" ? units.gu(1.5) : 0
                            visible: model.favourite == "1"
                        }

                        Label {
                            id: labelTime
                            text: DateUtils.formatRelativeTime(i18n, model.pubdate)
                            fontSize: "x-small"
                            width: parent.width - units.gu(2)
                            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                            opacity: 0.6
                        }
                    } // Row

                    Label {
                        id: labelTitle
                        objectName: "label_title"

                        text: model.title
                        anchors {
                            left: parent.left
                            right: parent.right
                        }
                        height: parent.height - parent.spacing * 2 - labelTime.paintedHeight - labelFeedname.paintedHeight
                        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                        fontSize: "small"
                        textFormat: Text.PlainText
                        font.weight: Font.DemiBold
                        elide: Text.ElideRight
                        opacity: model.status == "1" ? 0.4 : 0.8
                    }

                    Label {
                        id: labelFeedname
                        objectName: "labelFeedname"

                        text: model.feed_name
                        fontSize: "x-small"
                        anchors {
                            left: parent.left
                            right: parent.right
                        }
                        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                        opacity: 0.6
                    }
                } // Column


                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (mainView.isTabletMode)
                            pageItself.showArticle(model.index)
                        else mainView.showArticle(listViewModel, model.index)
                    }
                }
            }
        } //Rectangle
    } // Component



    ListView {
        id: articleList

        clip: true
        width: mainView.isTabletMode ? units.gu(50) : parent.width
        height: parent.height
        visible: true
        model: listViewModel

        delegate: listModeDelegate

        section {
            criteria: ViewSection.FullString
            property: isShorts ? "tagId" : "feedId"
            // labelPositioning: ViewSection.CurrentLabelAtStart | ViewSection.InlineLabels

            delegate: ListItems.Standard {

                ListItems.ThinDivider {}

                height: units.gu(5)
                text: textBySection()

                function textBySection() {
                    var s = section

                    if (listViewModel == null) {
                        return ""
                    }

                    if (isShorts) {
                        for (var i = 0; i < listViewModel.count; i++) {
                            if (listViewModel.get(i).tagId == s) {
                                return listViewModel.get(i).tagName
                            }
                        }
                    } else {
                        for (var i = 0; i < listViewModel.count; i++) {
                            if (listViewModel.get(i).feedId == s) {
                                return listViewModel.get(i).feed_name
                            }
                        }
                    }

                    return ""
                }
            }
        } // section
    } // ListView

//    ArticleViewItem {
//        id: listArticleView

//        isEmbeddedMode: mainView.isTabletMode
//        height: parent.height
//        anchors {
//            left: articleList.right
//            right: parent.right
//        }
//        visible: mainView.isTabletMode
//        showEmptyPlaceholder: (listViewModel && listViewModel.count)

//        // onVisibleChanged: if (visible) showArticle(0)
//    }

//    Connections {
//        target: listArticleView

//        onArticleStatusChanged: {
//            tabstabs.updateStatusInModels(tagId, articleId, status)
//        }

//        onArticleFavouriteChanged: {
//            tabstabs.updateFavouriteInModels(article, favourite)
//        }
//    }

    Component {
        id: readingOptionsPopoverComponent

        ReadingOptions { }
    } // Comp
} // Page
