import QtQuick 2.3
import U1db 1.0 as U1db
// import "databasemodule_v2.js" as DB

/* New interface for options.
 * Currently it is just facade on DB logic.
 */
Item {

    signal fontSizeChanged(int value)
    signal useDarkThemeChanged(bool value)
    signal useListModeChanged(bool value)

    function fontSize() {
        return settingsDocument.contents.fontSize
    }

    function setFontSize(value) {
        var cont = settingsDocument.contents
        cont.fontSize = value
        settingsDocument.contents = cont
        fontSizeChanged(value)
    }

    function useDarkTheme() {
        return settingsDocument.contents.useDarkTheme
    }

    function setUseDarkTheme(value) {
        var cont = settingsDocument.contents
        cont.useDarkTheme = value
        settingsDocument.contents = cont
        useDarkThemeChanged(value)
    }

    function useListMode() {
        return settingsDocument.contents.useListMode
    }

    function setUseListMode(value) {
        var cont = settingsDocument.contents
        cont.useListMode = value
        settingsDocument.contents = cont
        useListModeChanged(value)
    }

    function dbVersion() {
        return settingsDocument.contents.dbVersion
    }

    function setDbVersion(value) {
        var cont = settingsDocument.contents
        cont.dbVersion = value
        settingsDocument.contents = cont
    }

    function dbLastUpdate() {
        return settingsDocument.contents.dbLastUpdate
    }

    function setDbLastUpdate(value) {
        var cont = settingsDocument.contents
        cont.setDbLastUpdate = value
        settingsDocument.contents = cont
    }

    U1db.Database {
        id: settingsDataBase
        path: "ShortsSettings"
    }

    U1db.Document {
        id: settingsDocument
        database: settingsDataBase
        docId: 'settingsDocument'
        create: true
        defaults: { "useDarkTheme" : false, "fontSize" : 1, "useListMode" : false,
                    "dbVersion" : latestDBVersion, "dbLastUpdate" : ""}
    }
} // QtObject
