/*
  license GPL v3 ...........

  description of this file:
  a page for viewing a user selected RSS feed ;

*/

import QtQuick 2.3
import QtQuick.XmlListModel 2.0
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0
import "./dateutils.js" as DateUtils
import "databasemodule_v2.js" as DB

Popover {
    id: readingOptionsPopover

    Component.onCompleted: {
        fontSizeSlider.value = optionsKeeper.fontSize()
        buttonRow.updateButtonsState()
    }

    Column {
        id: contentColumn

        anchors {
            left: parent.left
            top: parent.top
            right: parent.right
        }

        ListItem.Empty {
            Row {
                id: buttonRow

                property bool useDark: false
                spacing: units.gu(2)
                anchors.centerIn: parent
                Button {
                    text: i18n.tr("Dark")
                    width: units.gu(14)
                    gradient: buttonRow.useDark ? UbuntuColors.orangeGradient : UbuntuColors.greyGradient
                    onClicked: {
                        optionsKeeper.setUseDarkTheme(true)
                        buttonRow.updateButtonsState()
                    }
                }

                Button {
                    text: i18n.tr("Light")
                    width: units.gu(14)
                    gradient: buttonRow.useDark ? UbuntuColors.greyGradient : UbuntuColors.orangeGradient
                    onClicked: {
                        optionsKeeper.setUseDarkTheme(false)
                        buttonRow.updateButtonsState()
                    }
                }

                function updateButtonsState() {
                    useDark = optionsKeeper.useDarkTheme()
                }
            }
        }

        ListItem.Empty {
            showDivider: false
            Label {
                id: lblLess

                text: "A"
                fontSize: "small"
                color: "black" // TODO TEMP
                anchors {
                    left: parent.left
                    leftMargin: units.gu(2)
                    verticalCenter: parent.verticalCenter
                }
            }

            Slider {
                id: fontSizeSlider

                anchors {
                    right: lblMore.left
                    rightMargin: units.gu(1)
                    left: lblLess.right
                    leftMargin: units.gu(1)
                    verticalCenter: parent.verticalCenter
                }

                minimumValue: 0
                maximumValue: 2

                onValueChanged: {
                    var res
                    if (value < maximumValue / 3)
                        res = 0
                    else if (value < maximumValue / 3 * 2)
                        res = 1
                    else res = 2

                    optionsKeeper.setFontSize(res)
                }

                function formatValue(v) {
                    if (v < maximumValue / 3)
                        return i18n.tr("Small")
                    else if (v < maximumValue / 3 * 2)
                        return i18n.tr("Mid")
                    else return i18n.tr("Large")
                }
            } // SLider

            Label {
                id: lblMore

                text: "A"
                fontSize: "large"
                color: "black" // TODO TEMP
                anchors {
                    right: parent.right
                    rightMargin: units.gu(2)
                    verticalCenter: parent.verticalCenter
                }
            }
        } // ListItem.Empty
    }
}
