import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0

import "databasemodule_v2.js" as DB

BaseTab {
    id: aSavedTab

    function reload() {
        clear()

        var articlesByTopic = []
        var topicArticles = DB.loadFavouriteArticles()
        var feedTags = DB.loadFeedTags()

        for (var j = 0; j < topicArticles.rows.length; j++) {
            var ca = topicArticles.rows.item(j)

            var anObj = {"tagName" : "",
                "tagId" : getTagByFeed(feedTags, ca.feed_id),
                "title" : ca.title,
                "content" : ca.content,
                "link" : ca.link,
                "author": ca.author,
                "description" : ca.description,
                "pubdate" : ca.pubdate,
                "status" : ca.status,
                "favourite" : ca.favourite,
                "feedId" : ca.feed_id,
                "image" : ca.image,
                "feed_name" : ca.feed_name,
                "media_groups" : ca.media_groups,
                "id" : ca.id }

            articlesByTopic.push(anObj)
        }

        // Sort for list mode.
        if (isListMode) {
            articlesByTopic.sort(function(a,b) {
                if (a.feedId === b.feedId)
                    return b.pubdate - a.pubdate
                else return b.feedId - a.feedId
            })
        }

        var commonModel = getModel()
        for(var i = 0; i < articlesByTopic.length; i++)
            commonModel.append(articlesByTopic[i])

        if (isListMode)
            listPage.reload()
        else gridPage.reload()

        modelCountChanged(commonModel.count)
    }

    function updateFavouriteInModel(article, fav) {
        if (fav == "1")
            appendArticle(article)
        else removeArticle(article)
    }

    function getTagByFeed(feedTags, feedId) {
        for (var j = 0; j < feedTags.rows.length; j++) {
            var ft = feedTags.rows.item(j)
            if (ft.feed_id == feedId)
                return ft.tag_id
        }

        console.log("ERROR: getTagByFeed, feed without tag, feedId:", feedId)
    }

    function removeArticle(article) {
        var commonModel = getModel()
        var articleId = article.id
        for ( var i = 0; i < commonModel.count; i++) {
            if (commonModel.get(i).id == articleId) {
                commonModel.get(i).favourite = "0"
                break
            }
        }

        modelCountChanged(commonModel.count)
    }

    function appendArticle(article) {
        var commonModel = getModel()
        var articleId = article.id
        /* Check if article already exist in model.
         */
        for ( var i = 0; i < commonModel.count; i++) {
            if (commonModel.get(i).id == articleId) {
                commonModel.get(i).favourite = "1"
                return
            }
        }

        /* Copying object is better than share, more robust.
         */
        var anObj = {"tagName" : article.tagName,
            "tagId" : article.tagId,
            "title" : article.title,
            "content" : article.content,
            "link" : article.link,
            "description" : article.description,
            "pubdate" : article.pubdate,
            "status" : article.status, // ?
            "favourite" : "1" /*article.favourite*/,
            "feedId" : article.feedId,
            "image" : article.image,
            "feed_name" : article.feed_name,
            "media_groups" : article.media_groups,
            "id" : article.id }

        if (!isListMode) {
            commonModel.append(anObj)
            gridPage.triggerLoadMore()
        } else {
            /* Cycle need to insert new item in correct place
             * to preserve right sections.
             */
            var j = 0
            for (; j < commonModel.count; j++) {
                if (commonModel.get(j).feedId == anObj.feedId) {
                    commonModel.insert(j, anObj)
                    break
                }
            }

            /* If no such section, simply append new item.
             */
            if (j == commonModel.count)
                commonModel.append(anObj)
        }

        modelCountChanged(commonModel.count)
    }
}
