import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0

import "databasemodule_v2.js" as DB

BaseTab {
    id: aShortsTab

    readonly property int __listModeCount: 8

    function reload() {
        // console.time("Shorts model update")
        clear()

        if (isListMode) {
            reloadList()
            listPage.reload()
        } else {
            reloadGrid()
            gridPage.reload()
        }

        modelCountChanged(getModel().count)
    }

    function clear() {
        gridPage.clear()
        listPage.clear()
        commonModelGrid.clear()
        commonModelList.clear()
    }

    function getModel() {
        if (isListMode)
            return commonModelList
        else return commonModelGrid
    }

    function getTagByFeed(feedTags, feedId) {
        for (var j = 0; j < feedTags.rows.length; j++) {
            var ft = feedTags.rows.item(j)
            if (ft.feed_id == feedId)
                return ft.tag_id
        }

        console.log("ERROR: getTagByFeed, feed without tag, feedId:", feedId)
    }

    function loadTags() { // TODO Optimize
        var tags = DB.loadTags()
        var tagArray = []
        for (var j = 0; j < tags.rows.length; j++) {
            tagArray.push(tags.rows.item(j))
        }
        return tagArray
    }

    function reloadList() {
        var tagArray = loadTags()

        for (var i = 0; i < tagArray.length; i++) {
            var curTag = tagArray[i]

            var tagArticles = DB.loadArticles({"tagId" : curTag.id})

            for (var j = 0; j < tagArticles.rows.length; j++) {
                var ca = tagArticles.rows.item(j)

                var articleObj = {"tagName" : curTag.name,
                    "tagId" : curTag.id,
                    "title" : ca.title,
                    "content" : ca.content,
                    "link" : ca.link,
                    "author": ca.author,
                    "description" : ca.description,
                    "pubdate" : ca.pubdate,
                    "status" : ca.status, // ?
                    "favourite" : ca.favourite,
                    "feedId" : ca.feed_id,
                    "image" : ca.image,
                    "feed_name" : ca.feed_name,
                    "media_groups" : ca.media_groups,
                    "id" : ca.id }

                commonModelList.append(articleObj)
                if (j >= __listModeCount)
                    break
            }
        }
    }

    function reloadGrid() {
        var feedArticles = DB.loadArticles({"isAll": true})
        var feedTags = DB.loadFeedTags()

        for (var i = 0; i < feedArticles.rows.length; i++) {
            var cart = feedArticles.rows.item(i)

            var artObj = {"tagName" : "",
                "tagId" : getTagByFeed(feedTags, cart.feed_id),
                "title" : cart.title,
                "content" : cart.content,
                "link" : cart.link,
                "author": cart.author,
                "description" : cart.description,
                "pubdate" : cart.pubdate,
                "status" : cart.status,
                "favourite" : cart.favourite,
                "feedId" : cart.feed_id,
                "image" : cart.image,
                "feed_name" : cart.feed_name,
                "media_groups" : cart.media_groups,
                "id" : cart.id }

            commonModelGrid.append(artObj)
        }
    }

    ListModel {
        id: commonModelGrid
        objectName: "commonModelGrid"
    }

    ListModel {
        id: commonModelList
        objectName: "commonModelList"
    }
}
