import QtQuick 2.3
import QtQuick.XmlListModel 2.0
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0

import "../databasemodule_v2.js" as DB

Page {
    id: chooseTopicPage

    objectName: "choosetopicpage"
    title: i18n.tr("Choose topic")
    flickable: null

    property var feedsToAdd: null
    signal topicChoosen(int topicId, var addedFeeds)

    function reloadPageContent() {
        // chooseTopicPage.tools = appendFeedTools
        suggestionTopicsModel.clear()

        var tags = DB.loadTags()

        for (var i = 0; i < tags.rows.length; i++) {
            var curTag = tags.rows.item(i)

            suggestionTopicsModel.append({"tagName" : curTag.name, "tagId" : curTag.id})
        }
    }

    function appendFeedsToTopic(topicId) {
        var tagId = topicId

        var updateList = []

        for(var i = 0; i < feedsToAdd.length; i++) {

            var f = feedsToAdd[i]

            // TODO should I remove html tags or not? :)
            var feedTitle = f.title
            feedTitle = feedTitle.replace(/<[^>]*>/g, '')

            var dbResult = DB.addFeed(feedTitle, f.url)

            if (dbResult.error) {
                // TODO Exist
                continue
            }

            DB.updateFeedByXml(dbResult.feedId, f.link, f.description, feedTitle)
            DB.addFeedTag(dbResult.feedId, tagId)

            updateList.push({"source" : f.url, "link" : f.link, "id" : dbResult.feedId})
        }

        pageStack.pop()
        pageStack.pop()

        topicChoosen(tagId, updateList)
    }

    ListView {
        id: suggestionTopics

        width: parent.width
        clip: true
        anchors {
            left: parent.left; right: parent.right
            top: parent.top; bottom: parent.bottom
//            bottomMargin: Qt.inputMethod.keyboardRectangle.height
        }

        model: suggestionTopicsModel

        header: ListItem.Header {
            ListItem.ThinDivider { }
            text: i18n.tr("Add your new feeds to a topic")
        }

        footer: Item {
                    width: parent.width
                    height: tfNewTopicName.height + units.gu(2)

                    TextField {
                        objectName: "newTopic"
                        id: tfNewTopicName

                        placeholderText: i18n.tr(" + New topic")

                        width: parent.width - units.gu(4)
                        anchors {
                            horizontalCenter: parent.horizontalCenter
                            verticalCenter: parent.verticalCenter
                        }

                        Connections {
                            id: connKeyBroad
                            target: Qt.inputMethod

                            onVisibleChanged: {
                                if (Qt.inputMethod.visible && pageStack && (pageStack.currentPage == chooseTopicPage)) {
        //                            console.log("kb show up", Qt.inputMethod.keyboardRectangle.height)
        //                            suggestionTopics.positionViewAtEnd()
                                    timerKeyboard.start()
                                }
                            }
                        }

                        /* a bad workaround for forcing TextField to show on the top of keyboard
                           flick the listview doesn't work because the keyboard needs about 400ms to show from bottom to top
                           if better workarounds come out, pls use it to replace the current one
                        */
                        Timer {
                            id: timerKeyboard
                            interval: 400; running: false; repeat: false; triggeredOnStart: false
                            onTriggered: suggestionTopics.positionViewAtEnd()
                        }

                        onAccepted: {
                            // Qt.inputMethod.hide()
                            var tagName = text.replace(/^\s+|\s+$/g, '')  // Trimming whitespaces.
                            if (tagName != "") { // Check that tagName contains only spaces.

                                /* Make first letter capital.
                                 */
                                tagName = tagName.charAt(0).toUpperCase() + tagName.slice(1)

                                var dbResult = DB.addTag(tagName)

                                if (dbResult.error) {
                                    PopupUtils.open(errorDialogComponent, chooseTopicPage,
                                                    {"text" : i18n.tr("A topic with this name already exists"),
                                                        "title" : i18n.tr("Warning")})
                                    return
                                }

                                suggestionTopicsModel.append({"tagName" : tagName,
                                                                 "tagId" : dbResult.tagId})

                                text = ""

                                appendFeedsToTopic(dbResult.tagId)
                            } else {
                                PopupUtils.open(errorDialogComponent, chooseTopicPage,
                                                {"text" : i18n.tr("Topic name can't contain only whitespaces"),
                                                    "title" : i18n.tr("Warning")})
                            }
                        }
                    }
                }

        delegate: ListItem.Standard {
            objectName: "topicItem"
            text: model.tagName

            onClicked: {
                console.log("Topic selected", model.tagId, model.tagName)

                appendFeedsToTopic(model.tagId)
            }
        }
    }

    ListModel {
        id: suggestionTopicsModel
    }
}
