import QtQuick 2.3
import QtQuick.XmlListModel 2.0
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0

import "../databasemodule_v2.js" as DB

Page {
    id: createTopicPage

    title:  i18n.tr("Create new topic")
    visible: false
    flickable: null

    signal topicAdded()

    Rectangle {
        id: fakePanel

        color: "#fafafa"
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }
        height: units.gu(6)
        Item {
            anchors.fill: parent

            Button {
                anchors {
                    verticalCenter: parent.verticalCenter
                    left: parent.left
                    leftMargin: units.gu(1)
                }
                action: Action {
                    text:  i18n.tr("Cancel")

                    onTriggered: {
                        pageStack.pop()
                    }
                }
            }

            Button {
                id: addTopicBtn

                enabled: tfTopicName.length > 0
                anchors {
                    verticalCenter: parent.verticalCenter
                    right: parent.right
                    rightMargin: units.gu(1)
                }
                action: Action {
                    text:  i18n.tr("Add topic")

                    onTriggered:
                    {
                        if (!addTopicBtn.enabled)
                            return

                        var topicName = tfTopicName.text.replace(/^\s+|\s+$/g, '') // Trimming whitespaces.
                        if (topicName == "") {
                            PopupUtils.open(errorDialogComponent, createTopicPage,
                                            {"text" : i18n.tr("Topic name can't contain only whitespaces"),
                                                "title" : i18n.tr("Warning")})
                            return
                        }

                        /* Make first letter capital.
                         */
                        topicName = topicName.charAt(0).toUpperCase() + topicName.slice(1)

                        var dbResult = DB.addTag(topicName)
                        if (dbResult.error) {
                            PopupUtils.open(errorDialogComponent, createTopicPage,
                                            {"text" : i18n.tr("A topic with this name already exists"),
                                                "title" : i18n.tr("Warning")})
                            return
                        } else {
                            tfTopicName.text = ""

                            for( var i = 0; i < suggestionFeedsModel.count; i++) {
                                var curItem = suggestionFeedsModel.get(i)

                                if (curItem.feedSelected) {
                                    DB.addFeedTag(curItem.feedId, dbResult.tagId)
                                }
                            }
                        }

                        topicAdded()
                        pageStack.pop()
                    }
                }
            } // Button
        }
    } // Rectangle fakePanel

    function reloadPageContent() {
        suggestionFeedsModel.clear()

        //var feeds = DB.loadFeeds()
        var feeds = DB.loadFeedsWithoutTopic()

        for( var i = 0; i < feeds.rows.length; i++) {
            var curFeed = feeds.rows.item(i)

            suggestionFeedsModel.append({"title" : curFeed.title,
                                            "feedId" : curFeed.id,
                                            "feedSelected" : false})
        }
        tools = createTopicTools
    }

    Column {
        id: someColumn

        anchors.top: parent.top
        anchors.topMargin: units.gu(2)
        width: parent.width
        spacing: units.gu(2)

        TextField {
            id: tfTopicName

            placeholderText: i18n.tr("Type topic name")

            width: parent.width - units.gu(4)
            anchors {
                horizontalCenter: parent.horizontalCenter
            }

            onAccepted: {
                Qt.inputMethod.hide()
            }
        }

        ListItem.Header {

            ListItem.ThinDivider { }

            text: i18n.tr("Select feeds (optional)")
        }
    } // Column


    ListView {
        id: suggestionFeeds

        width: parent.width
        clip: true
        anchors {
            bottom: fakePanel.top
            // bottomMargin: createTopicTools.height
            top: someColumn.bottom
        }

        model: suggestionFeedsModel

        delegate: ListItem.Standard {
            text: model.title
            control: CheckBox {
                anchors.verticalCenter: parent.verticalCenter

                onCheckedChanged: {
                    suggestionFeedsModel.setProperty(index, "feedSelected", checked)
                }
            }
        }
    }

    ListModel {
        id: suggestionFeedsModel
    }

    Label {
        visible: suggestionFeedsModel.count == 0
        anchors {
           centerIn: suggestionFeeds
        }
        text: i18n.tr("No feeds")
        fontSize: "large"
    }

} // Page
