/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 *              Martin Borho <martin@borho.net>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Layouts 1.0
import "./" as Components

Rectangle {
    id: backrect
    color: "transparent"
    property int shapeSize: units.gu(15)
    property int gridColumns: 2

    function getPrecipLabel() {
        // show the right Label, depending on precipitation type
        return (currentWeather.precipType === "snow") ? i18n.tr("Snow") : i18n.tr("Rain")
    }

    function getUvLabel() {
        var label = "",
            uvInt = parseInt(currentWeather.uvIndex);
        if(uvInt <= 2) {
            label = i18n.tr("Low");
        } else if(uvInt <= 5) {
            label = i18n.tr("Moderate");
        } else if(uvInt <= 8) {
            label = i18n.tr("High");
        } else if(uvInt <= 10) {
            label = i18n.tr("Very high");
        } else {
            label = i18n.tr("Extreme");
        }
        return label;
    }

    Grid {
        columns: gridColumns
        spacing: units.gu(1)
        anchors {
            horizontalCenter: parent.horizontalCenter
            verticalCenter: parent.verticalCenter
        }

        UbuntuShape {
            color: "#10000000"
            radius: "medium"

            width: shapeSize
            height: shapeSize

            Components.WeatherDetailComponent {
                value: currentWeather.humidity
                measure: i18n.tr("Humidity")
                unit: i18n.tr('%')
                anchors.fill: parent
            }
        }

        UbuntuShape {
            color: "#10000000"
            radius: "medium"

            width: shapeSize
            height: shapeSize

            Components.WeatherDetailComponent {
                objectName: "WindSpeedValue"
                value: currentWeather.windSpeed
                measure: i18n.tr("Wind speed")
                unit: currentWeather.speedScale + " " + currentWeather.windDir
                anchors.fill: parent
            }
        }

        UbuntuShape {
            color: "#10000000"
            radius: "medium"

            width: shapeSize
            height: shapeSize

            Components.WeatherDetailComponent {
                value: (currentWeather.propPrecip !== "") ? currentWeather.propPrecip: currentWeather.pressure
                measure: (currentWeather.propPrecip !== "") ?  getPrecipLabel(): i18n.tr("Pressure")
                unit: (currentWeather.propPrecip !== "") ? "% " + i18n.tr("chance") : i18n.tr("mbar")
                anchors.fill: parent
            }
        }

        UbuntuShape {
            color: "#10000000"
            radius: "medium"

            width: shapeSize
            height: shapeSize

            Components.WeatherDetailComponent {
                objectName: "PrecipitationValue"
                value: (currentWeather.uvIndex !== "") ? currentWeather.uvIndex : currentWeather.precipitation
                measure: (currentWeather.uvIndex !== "") ? i18n.tr("UV index"): i18n.tr("Precipitation")
                unit: (currentWeather.uvIndex !== "") ? getUvLabel() : currentWeather.precipScale;
                anchors.fill: parent
            }
        }
    }
}
