/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 *              Martin Borho <martin@borho.net>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Layouts 1.0
import "./" as Components

Rectangle {
    id: frontrect
    color: "transparent"

    property alias condition: currentCondition
    property alias conditionIcon: currentConditionIcon
    property alias conditionTempContent: currentConditionTempContent
    property alias conditionTemp: currentConditionTemp
    property int shapeSize: (viewMode == 0) ? units.gu(15) : units.gu(28)
    property int viewMode // 0: Mobile, 1: Tablet

    UbuntuShape {
        id: currentCondition
        color: "#10000000"
        radius: "medium"

        width: shapeSize
        height: shapeSize
        anchors {
            horizontalCenter: parent.horizontalCenter
            horizontalCenterOffset: -(shapeSize*0.53)//units.gu(-8)
            verticalCenter: parent.verticalCenter
        }

        Components.WeatherConditionIconComponent {
            id: currentConditionIcon
            anchors.centerIn: parent
            anchors.margins: units.gu(1)
            condition: currentWeather.icon
            viewMode: frontrect.viewMode
        }
    }

    UbuntuShape {
        id: currentConditionTemp
        color: "#10000000"
        radius: "medium"
        width: shapeSize
        height: shapeSize
        anchors {
            horizontalCenter: parent.horizontalCenter
            horizontalCenterOffset: shapeSize*0.53//units.gu(8)
            verticalCenter: parent.verticalCenter
        }

        Components.WeatherTemperatureComponent {
            id: currentConditionTempContent
            currentTemp: Math.round(currentWeather.currentTemp)
            tempScale: currentWeather.tempScale
            minTemp: Math.round(currentWeather.minTemp)
            maxTemp: Math.round(currentWeather.maxTemp)
            anchors.fill: parent

            viewMode: frontrect.viewMode
        }
    }
}
