/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Martin Borho <martin@borho.net>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1

Rectangle {
    anchors {
        left: parent.left
        right:parent.right
    }
    height: units.gu(4)
    color: "transparent"
    property string dateRelative: ""
    property string dateString: ""

    Component.onCompleted: {        
        renderText()
    }

    function renderText() {
        var dateText = ""
        if(dateRelative !== "") {
            dateText += dateRelative+", ";
        }
        dateText += dateString
        dayText.text = dateText
    }

    Label {
        id: dayText
        objectName: "DayDateLabel"
        anchors {
            fill: parent
            leftMargin: units.gu(2.2)
        }
        verticalAlignment: Text.AlignVCenter
        color: Theme.palette.normal.baseText
        style: Text.Raised
    }
}
