.pragma library
/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Martin Borho <martin@borho.net>
 */

var map = {
    "40": "#8c009c",
    "38": "#76007f",
    "36": "#65005f",
    "34": "#600043",
    "32": "#67002e",
    "30": "#790023",
    "28": "#92001d",
    "26": "#ac0019",
    "24": "#c30213",
    "22": "#d8070c",
    "20": "#e91109",
    "18": "#E11D07",
    "16": "#DD2B0C",
    "14": "#E04414",
    "12": "#E1581D",
    "10": "#E17126",
    "8": "#E18433",
    "6": "#E1983E",
    "4": "#E1A84C",
    "2": "#E1B75B",
    "0": "#E1C169",
    "-2": "#E1CB78",
    "-4": "#DFD78E",
    "-6": "#D4DFA6",
    "-8": "#B3D9A4",
    "-10": "#91D0A1",
    "-12": "#85e4bd",
    "-14": "#64d9c9",
    "-16": "#43c9d3",
    "-18": "#27b3d9",
    "-20": "#1497d7",
    "-22": "#0878cf",
    "-24": "#055ac3",
    "-26": "#0641b6",
    "-28": "#0b2ca8",
    "-30": "#191f9b",
    "-32": "#261b97",
    "-34": "#2b1b97",
    "-36": "#311c97",
    "-38": "#381d97",
    "-40": null
}

var getGradients = function(celsius) {
    // move warm colors up
    celsius -= 8
    // stay in range
    if(celsius < -30) celsius = -30;
    else if(celsius > 40) celsius = 40;
    // get anchor value
    celsius = (celsius % 2 == 1 || celsius % 2 == -1) ? celsius +1 : celsius;
    //
    return {
        header: map[celsius],
        body: map[celsius-4],
        footer: map[celsius-8]
    }
}
