/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Martin Borho <martin@borho.net>
 *              Andrew Starr-Bochicchio <a.starr.b@gmail.com>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1

Rectangle {
    height: units.gu(4)
    anchors {
        left: parent.left
        right:parent.right
        bottom: parent.bottom
        bottomMargin: units.gu(2)
    }
    color: "transparent"

    property string updateDate;

    onUpdateDateChanged: {
        var updatedLabel = i18n.tr("Updated: "),
            updated = new Date(parseInt(updateDate)),
            updateTime = Qt.formatTime(updated);
        if(Qt.formatDateTime(updated, i18n.tr("yyyy-MM-dd")) === Qt.formatDateTime(new Date(), i18n.tr("yyyy-MM-dd"))) {
            updatedLabel += i18n.tr("Today, ")+updateTime;
        } else {
            updatedLabel += Qt.formatDate(updated, i18n.tr("dddd, dd MMMM "))+updateTime;
        }
        lastUpdatedLabel.text = updatedLabel
    }

    Label {
        id: lastUpdatedLabel
        objectName: "LastUpdatedLabel"
        anchors {
            fill: parent
            leftMargin: units.gu(2.2)
        }
        verticalAlignment: Text.AlignVCenter
        color: Theme.palette.normal.baseText
        style: Text.Raised
    }
}
