/*
 * Copyright (C) 2013,2014 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 *              Martin Borho <martin@borho.net>
 */

import QtQuick 2.3
import Ubuntu.Components 1.1

Rectangle {
    Image {
        id: image1
        anchors.fill: parent
        anchors.margins: units.gu(10)
        source: "../resources/images/ubuntu-logo.png"
        fillMode: Image.PreserveAspectFit
    }

    RotationAnimation {
        running: true
        targets: image1
        properties: "rotation"
        from: 0
        to: 360
        loops: Animation.Infinite
        duration: UbuntuAnimation.SleepyDuration
    }
}
