/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Martin Borho <martin@borho.net>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1

UbuntuShape {
    id: httpFailedSplash    
    color: "#F5F5F5"
    visible: (opacity > 0.0)
    opacity: 0
    z:100
    anchors {
        top: parent.top
        topMargin:units.gu(15)
        left: parent.left
        leftMargin: units.gu(5)
        right: parent.right
        rightMargin: units.gu(5)
    }
    property string message: i18n.tr("Couldn't load weather data, please try later again!")

    Label {
        text: message
        anchors.fill:parent
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        fontSize: "medium"
        color: "#838383"
        wrapMode: Text.WordWrap
    }
    Timer {
        id: splashTimer
        interval: 2000
        repeat: false
        onTriggered: {
            hideSplashBox.start()
        }
    }
    NumberAnimation {
        id: hideSplashBox
        target: httpFailedSplash
        properties: "opacity"
        from: 1
        to: 0
        easing: UbuntuAnimation.StandardEasing
        duration: UbuntuAnimation.SleepyDuration
    }
    NumberAnimation {
        id: showSplashBox
        target: httpFailedSplash
        properties: "opacity"
        from: 0
        to: 1
        easing: UbuntuAnimation.StandardEasing
        duration: UbuntuAnimation.BriskDuration
    }
    function show() {
        showSplashBox.start()
        splashTimer.start()
    }
}
