/*
 * Copyright (C) 2014 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Martin Borho <martin@borho.net>
 */
import QtQuick 2.3
import Ubuntu.Components 1.1

Rectangle {
    height: units.gu(8)
    anchors {
        left: parent.left
        right: parent.right
        bottom: parent.bottom
    }

    function openTWCLink(type) {
        // See https://bugs.launchpad.net/ubuntu-weather-app/+bug/1355835
        // Mobile links are set as default until TWC has its mobile-switch fixed
        var serviceId = locationTab.locationData.location.services["weatherchannel"],
            loc_name = Qt.locale().name,
            url = "http://m.";
        print("Open link for "+type+" - "+loc_name)
        if(loc_name.search(/^de_/) > -1) {
            url += "de.weather.com/";
            if(type) url += ((type === "10day") ? "10tage/" : "stündlich/");

        } else if(loc_name === "en_US" || loc_name === "en-CA") {
            //url += "www.weather.com/"; //desktop
            url += "weather.com/";
            if(type) url += "weather/"+((type === "10day") ? "tenday/" : "hourbyhour/graph/");

        } else if(loc_name.search(/^en_/) > -1) {
            url += "uk.weather.com/";
            //if(type) url += "weather/"+((type === "10day") ? "10day-" : "hourByHour-"); //desktop
            if(type) url += ((type === "10day") ? "10day/" : "hourly/");

        } else if(loc_name.search(/^fr_/) > -1) {
            url += "fr.weather.com/";
            if(type) url += ((type === "10day") ? "10jours/" : "horaire/");

        } else if(loc_name.search(/^es_/) > -1) {
            //url += "espanol.weather.com/"; //desktop
            // if(type) url += "weather/"+((type === "10day") ? "10day-" : "hourByHour-"); //desktop
            url += "es.weather.com/";
            if(type) url += ((type === "10day") ? "10días/" : "por_hora/");

        } else if(loc_name === "ja_JP") {
            url += "ja.weather.com/";
            if(type) url += ((type === "10day") ? "10日/" : "1時間ごと/");

        } else if(loc_name.search(/^zh_/) > -1) {
            url += "zh.weather.com/";
            if(type) url += ((type === "10day") ? "10天/" : "1時間ごと/");

        } else if(loc_name === "pt_BR") {
            url += "br.weather.com/";
            if(type) url += ((type === "10day") ? "10dias/" : "toda_hora/");

        } else if(loc_name.search(/^pt_/) > -1) {
            url += "pt.weather.com/";
            if(type) url += ((type === "10day") ? "10dias/" : "cadahora/");

        } else if(loc_name === "ru_RU") {
            url += "ru.weather.com/";
            if(type) url += ((type === "10day") ? "10дней/" : "ежечасно/");
        } else {
            //url += "www.weather.com/"; //desktop
            url += "weather.com/";
            if(type) url += "weather/"+((type === "10day") ? "tenday/" : "hourbyhour/graph/");
        }

        if(type) url += serviceId;
        url += "?par=ubuntu"
        print(url)
        Qt.openUrlExternally(url);
    }

    Rectangle {
        id: forecastLink
        anchors {
            left:parent.left
            leftMargin: units.gu(1)
            top: parent.top
            bottom:parent.bottom
        }
        width:units.gu(14)
        Label {
            verticalAlignment: Text.AlignVCenter
            anchors {
                bottom: parent.bottom
                top: parent.top
            }
            text: i18n.tr("10 days forecast")
            fontSize:"medium"
            color: mainView.footerColor
            MouseArea {
                anchors.fill:parent
                onClicked: openTWCLink("10day")
            }
        }
    }
    Rectangle {
        anchors {
            top: parent.top
            bottom:parent.bottom
            left:forecastLink.right
        }
        width:units.gu(15)
        Label {
            verticalAlignment: Text.AlignVCenter
            anchors {
                bottom: parent.bottom
                top: parent.top
            }
            text: ">> "+i18n.tr("Hourly forecast")
            fontSize:"medium"
            color: mainView.footerColor
            MouseArea {
                anchors.fill:parent
                onClicked: openTWCLink("hourly")
            }
        }
    }
    Rectangle {
        width:units.gu(0.25)
        anchors {
            top: parent.top
            bottom:parent.bottom
            right: serviceLogo.left
        }
        color: mainView.footerColor
    }
    Rectangle {
        id: serviceLogo
        width:units.gu(9)
        anchors {
            top: parent.top
            bottom:parent.bottom
            right: parent.right
        }
        Label {
            anchors.verticalCenter: parent.verticalCenter
            anchors.centerIn: parent
            fontSize: "medium"
            font.bold: true
            color:mainView.footerColor
            text: "The\nWeather\nChannel"
        }
        MouseArea {
            anchors.fill:parent
            onClicked: openTWCLink()
        }
    }
}
