/*
 * Copyright (C) 2013,2014 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 *              Martin Borho <martin@borho.net>
 */

import QtQuick 2.3
import Ubuntu.Components 1.1
import "./" as Components

Rectangle {
    id: weatherCondition
    color: "transparent"
    height: units.gu(18)
    width: units.gu(19)
    state: ""

    property string condition: ""
    property int velocity: 50
    property int currentImage: 1
    property int totalImage: 50
    property NumberAnimation appearAnimation : appear

    property int viewMode // 0: mobile, 1: tablet

    Image {
        id: icon
        anchors.centerIn: parent
        source: "../resources/images/"+condition+"/"+currentImage+".png"
        height: (viewMode == 0) ? units.gu(18) : units.gu(30)
        width: (viewMode == 0) ? units.gu(18) : units.gu(30)
    }

    NumberAnimation {
        id: appear;
        target: weatherCondition;
        property: "currentImage";
        from: 1; to: totalImage;
        duration: UbuntuAnimation.SleepyDuration;
    }


    ParallelAnimation {
        id: change
        NumberAnimation {
            target: weatherCondition;
            property: "currentImage";
            from: 12;
            to: totalImage;
            duration: UbuntuAnimation.SleepyDuration;
        }
        NumberAnimation {
            target: weatherCondition;
            property: "opacity";
            from: 0.8;
            to: 1;
            duration: UbuntuAnimation.FastDuration;
            easing: UbuntuAnimation.StandardEasing;
        }
    }

    onConditionChanged: {change.restart()}
}
