/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 */
import QtQuick 2.3
import QtGraphicalEffects 1.0
import Ubuntu.Components 1.1

Rectangle {
    id: infoComponent
    color: "transparent"

    anchors {
        fill: parent
    }

    property real value
    property string measure
    property string unit

    Rectangle {
        id: measure
        height: parent.height*0.15
        color: "transparent"
        anchors {
            right: parent.right
            rightMargin: units.gu(1)
            left: parent.left
            leftMargin: units.gu(2)
            top: parent.top
            topMargin: units.gu(1.5)
        }
        Label {
            anchors.fill: parent
            text: infoComponent.measure
            color: Theme.palette.normal.baseText
            fontSize: "medium"
            style: Text.Raised
            elide: Text.ElideRight
            verticalAlignment: Text.AlignVCenter
        }
    }

    Rectangle {
        id:line1
        color: "#55000000"
        anchors {
            top: measure.bottom
            topMargin: units.gu(0.5)
            left: parent.left
            leftMargin: units.gu(2)
            right: parent.right
            rightMargin: units.gu(2)
        }
        height: 1
        width: units.gu(10)
    }

    Rectangle {
        color: "#55FFFFFF"
        anchors {
            top: line1.bottom
            bottomMargin: 1
            left: line1.left
            right: line1.right
        }
        height: 1
        width: units.gu(10)
    }

    Text {
        id: value
        objectName: "WeatherDetailValue"
        text: infoComponent.value.toPrecision()
        color: Theme.palette.normal.baseText
        style: Text.Raised
        font.bold: false
        font.family: "Ubuntu"
        font.pixelSize: units.gu(5.5)
        fontSizeMode: Text.Fit
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignLeft
        anchors {
            verticalCenter: parent.verticalCenter
            left: parent.left
            leftMargin: units.gu(2)
            right: parent.right
            rightMargin: units.gu(2)
        }
    }

    Rectangle {
        id: line2
        color: "#55000000"
        anchors {
            bottom: unit.top
            bottomMargin: units.gu(0.5)
            left: parent.left
            leftMargin: units.gu(2)
            right: parent.right
            rightMargin: units.gu(2)
        }
        height: 1
        width: units.gu(10)
    }

    Rectangle {
        color: "#55FFFFFF"
        anchors {
            top: line2.bottom
            bottomMargin: 1
            left: line2.left
            right: line2.right
        }
        height: 1
        width: units.gu(10)
    }

    Rectangle {
        id: unit
        height: parent.height*0.15
        color: "transparent"
        anchors {
            right: parent.right
            rightMargin: units.gu(1)
            left: parent.left
            leftMargin: units.gu(2)
            bottom: parent.bottom
            bottomMargin: units.gu(1.5)
        }
        Label {
            objectName: "WeatherDetailUnit"
            anchors.fill: parent
            text: infoComponent.unit
            fontSize: "small"
            color: Theme.palette.normal.baseText
            style: Text.Raised
            elide: Text.ElideRight
            verticalAlignment: Text.AlignVCenter
        }
    }
}
