/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Raúl Yeguas <neokore@gmail.com>
 */
import QtQuick 2.3
import QtGraphicalEffects 1.0
import Ubuntu.Components 1.1
import Ubuntu.Layouts 1.0

Rectangle {
    id: tempComponent
    color: "transparent"

    property int currentTemp
    property string tempScale
    property int maxTemp
    property int minTemp

    property int viewMode // 0: Mobile, 1: Tablet

    Layouts {
        objectName: "WeatherTemperatureLayout"
        id: layoutsCurrentTemp

        anchors.fill: parent

        Text {
            id: value
            objectName: "CurrentTempText"
            text: tempComponent.currentTemp
            color: Theme.palette.normal.baseText
            style: Text.Raised
            font.bold: false
            font.family: "Ubuntu"
            font.pixelSize: (viewMode == 0) ? units.gu(9) : units.gu(18)
            font.letterSpacing: -2
            fontSizeMode: Text.Fit
            verticalAlignment: Text.AlignTop
            horizontalAlignment: Text.AlignRight
            height: (viewMode == 0) ? units.gu(9) : units.gu(18)
            width: (viewMode == 0) ? units.gu(9) : units.gu(18)
            anchors {
                top: parent.top
                topMargin: units.gu(1)
                left: parent.left
                leftMargin: units.gu(1)
            }
        }
        Text {
            id: currentTempScale
            objectName: "CurrentTempScale"
            text: String("°") + tempComponent.tempScale
            style: Text.Raised
            font.bold: false
            font.family: "Ubuntu"
            font.pixelSize: (viewMode == 0) ? units.gu(2.5) : units.gu(5)
            verticalAlignment: Text.AlignTop
            horizontalAlignment: Text.AlignLeft
            color: Theme.palette.normal.baseText
            height: units.gu(9)
            anchors {
                top: value.top
                topMargin: units.gu(0.5)
                left: value.right
            }
        }

        Rectangle {
            id: line2
            color: "#55000000"
            anchors {
                bottom: max.top
                bottomMargin: (viewMode == 0) ? 0 : units.gu(1)
                left: parent.left
                leftMargin: units.gu(2)
                right: parent.right
                rightMargin: units.gu(2)
            }
            height: 1
            width: units.gu(10)

        }
        Rectangle {
            color: "#55FFFFFF"
            anchors {
                top: line2.bottom
                bottomMargin: 1
                left: line2.left
                right: line2.right
            }
            height: 1
            width: units.gu(10)

        }


        Text {
            id: max
            // TRANSLATORS: this refers to the High (max) temperature forecasted for a day, use 1 character at maximum!
            text: i18n.tr("H:") + " " + tempComponent.maxTemp
            color: Theme.palette.normal.baseText
            style: Text.Raised
            font.bold: false
            font.family: "Ubuntu"
            font.pixelSize: (viewMode == 0) ? units.gu(2) : units.gu(3.5)
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            visible: (dailyForecastList.currentIndex === 0 && tempComponent.maxTemp !== undefined)
            anchors {
                bottom: parent.bottom
                bottomMargin: units.gu(2)
                left: parent.left
                leftMargin: units.gu(2)
            }
        }

        Label {
            id: min
            // TRANSLATORS: this refers to the Low (min) temperature forecasted for a day, use 1 character at maximum!
            text: i18n.tr("L:") + " " + tempComponent.minTemp
            color: Theme.palette.normal.baseText
            style: Text.Raised
            font.bold: false
            font.family: "Ubuntu"
            font.pixelSize: (viewMode == 0) ? units.gu(2) : units.gu(3.5)
            fontSizeMode: Text.Fit
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            anchors {
                bottom: parent.bottom
                bottomMargin: units.gu(2)
                right: parent.right
                rightMargin: units.gu(2)
            }
        }
    }
}
