/*
 * Copyright 2014 Canonical Ltd.
 *
 * This file is part of ubuntu-html5-ui-toolkit.
 *
 * ubuntu-html5-ui-toolkit is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * ubuntu-html5-ui-toolkit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 1.0
import Ubuntu.Components.Extras.Browser 0.1
import QtWebKit.experimental 1.0
import Ubuntu.UnityWebApps 0.1

MainView {
    id: root

    width: units.gu(100)
    height: units.gu(75)

    anchorToKeyboard: true
    automaticOrientation: true

    Page {
        id: page

        title: ""

        Timer {
            id: checkTimer
            running: true
            repeat: false
            onTriggered: {
                webviewComponentLoader.sourceComponent = webviewComponent
                checkTimer.stop()
            }
            interval: 100
        }

        Loader {
            id: webviewComponentLoader
            anchors.fill: parent
            onLoaded: webappsComponentLoader.sourceComponent = webappsComponent
        }

        Component {
            id: webviewComponent

            UbuntuWebView {
                objectName: 'webview'
                maximumFlickVelocity: height * 5

                experimental.preferences.localStorageEnabled: true
                experimental.preferences.offlineWebApplicationCacheEnabled: true
                experimental.preferences.universalAccessFromFileURLsAllowed: true
                experimental.preferences.webGLEnabled: true

                experimental.databaseQuotaDialog: Item {
                    Timer {
                        interval: 1
                        running: true
                        onTriggered: {
                            model.accept(model.expectedUsage)
                        }
                    }
                }

                // port in QTWEBKIT_INSPECTOR_SERVER enviroment variable
                experimental.preferences.developerExtrasEnabled: true

                onNewTabRequested: {
                    if (url.toString().indexOf("file://") !== 0) {
                        Qt.openUrlExternally(url.toString())
                        return
                    }
                }
            }
        }

        function getUnityWebappsProxies() {
            return UnityWebAppsUtils.makeProxiesForQtWebViewBindee(
                        webviewComponentLoader.item);
        }

        Loader {
            id: webappsComponentLoader
            anchors.fill: parent
            onLoaded: webviewComponentLoader.sourceComponent = webviewComponent
        }

        Component {
            id: webappsComponent

            UnityWebApps {
                id: webapps
                bindee: page
                injectExtraUbuntuApis: true
                requiresInit: false

                Component.onCompleted: {
                    webviewComponentLoader.item.url =
                            HtmlIndexDirectory !== "" ?
                                ('file://' + HtmlIndexDirectory + '/index.html') : ""
                }
            }
        }
    }
}
