import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import Ubuntu.Components.Popups 1.0

import "databasemodule_v2.js" as DB

Tab {
    id: baseTab

    signal modelCountChanged(int count)

    property bool isListMode: pageStack ? pageStack.isListView : false
    property int topicId: -1

    property Item listPage: listModePage
    property Item gridPage: gridModePage
    property bool modelEmpty: false

    /* Tab displays its contents only when selected. */
    property bool __isActive: false

    page: Page {
        id: contentPage

        head.actions: pageStack ? pageStack.commonHeadActions : null

        ListModePage {
            id: listModePage

            visible: isListMode
            anchors.fill: parent
            topicId: baseTab.topicId
        }

        GridModePage {
            id: gridModePage

            visible: !isListMode
            anchors.fill: parent
            topicId: baseTab.topicId
        }
    }

    onIsListModeChanged: {
        if (topicId == -1) // Ignore first undefined state.
            return

        reload()
    }

    onModelCountChanged: {
        modelEmpty = count === 0
    }

    function reload() {
        // console.log('baseTab reload', topicId)
        clear()

        var articlesByTopic = []
        var topicArticles = DB.loadArticles({"tagId" : topicId})

        for (var j = 0; j < topicArticles.rows.length; j++) {
            var ca = topicArticles.rows.item(j)

            var anObj = {"tagName" : "",
                "tagId" : topicId,
                "title" : ca.title,
                "content" : ca.content,
                "link" : ca.link,
                "author": ca.author,
                "description" : ca.description,
                "pubdate" : ca.pubdate,
                "status" : ca.status, // ?
                "favourite" : ca.favourite,
                "feedId" : ca.feed_id,
                "image" : ca.image,
                "feed_name" : ca.feed_name,
                "media_groups" : ca.media_groups,
                "id" : ca.id }

            articlesByTopic.push(anObj)
        }

        // Sort for list mode.
        if (isListMode) {
            articlesByTopic.sort(function(a,b) {
                if (a.feedId === b.feedId)
                    return b.pubdate - a.pubdate
                else return b.feedId - a.feedId
            })
        }

        var commonModel = getModel()
        for(var i = 0; i < articlesByTopic.length; i++)
            commonModel.append(articlesByTopic[i])

        modelCountChanged(commonModel.count)
    }

    function clear() {
        __isActive = false
        gridPage.clear()
        listPage.clear()
        getModel().clear()
    }

    function showContent() {
        //.console.log("showContent: ", topicId, isActive)
        if (__isActive)
            return

        __isActive = true
        if (isListMode)
            listPage.reload()
        else gridPage.reload()
    }

    /* All views should use this method to access shared model.
     */
    function getModel() {
        return commonSharedModel
    }

    function updateStatusInModel(articleId, status) {
        var usedModel = getModel()

        for ( var i = 0; i < usedModel.count; i++) {
            if (usedModel.get(i).id === articleId) {
                usedModel.get(i).status = status
                break
            }
        }
    }

    function updateFavouriteInModel(articleId, fav) {
        var usedModel = getModel()

        for ( var i = 0; i < usedModel.count; i++) {
            if (usedModel.get(i).id === articleId) {
                usedModel.get(i).favourite = fav
                break
            }
        }
    }

    ListModel {
        id: commonSharedModel
    }

    Label {
        id: lblEmptyBase

        text: i18n.tr("There are no articles to show")
        visible: modelEmpty
        anchors.centerIn: parent
        fontSize: "large"
    }
}
