import QtQuick 2.3
import Ubuntu.Components 1.1
import Ubuntu.Components.ListItems 1.0 as ListItem
import "../dateutils.js" as DateUtils
import "../databasemodule_v2.js" as DB

UbuntuShape
{
    id: articleFullImg

    property bool invalid: false
    property var modelItem
    property var rssModel
    property int modelIndex

    // property string secretProp: ""

    width: units.gu(24)
    height: units.gu(20)
    radius: "medium"
    color: invalid ? "black" : modelItem.status == "1" ? Qt.rgba(0, 0, 0, 0.7) : Qt.rgba(0, 0, 0, 0.4)


    onModelItemChanged: {
        if (modelItem == null) {
            invalid = true
        }
    }

    Item {
        id: shapeClipper

        anchors {
            left: parent.left
            right: parent.right
        }
        height: uPic.height > (articleFullImg.height * 0.46) ? (articleFullImg.height * 0.46) : (uPic.height == 0 ? units.gu(1) : (uPic.height - units.gu(1.2)))
        clip: true

        UbuntuShape {
            id: uPic

            anchors {
                left: parent.left
                right: parent.right
            }
            height: pic.height > (articleFullImg.height - units.gu(1.5)) ? (articleFullImg.height - units.gu(1.5)) : pic.height
            radius: "medium"
            opacity: height
            image: Image {
                id: pic
                width: {
                    if (implicitHeight < 50 || implicitWidth < 50) return 0
                    else return uPic.width
                }
                height: width * implicitHeight / implicitWidth
                source: invalid ? "" : modelItem.image
                sourceSize.width: uPic.width
            }

            Behavior on height { UbuntuNumberAnimation{} }
            Behavior on opacity { NumberAnimation{} }
        }
    }

    Column {
        id: content

        anchors {
            top: shapeClipper.bottom
            topMargin: units.gu(1)
            bottom: parent.bottom
            bottomMargin: units.gu(1.5)
            left: parent.left
            leftMargin: units.gu(1)
            right: parent.right
            rightMargin: units.gu(1)
        }
        spacing: units.gu(0.8)

        Row {
            anchors {
                left: parent.left
                right: parent.right
            }
            height: labelTime.height
            spacing: units.gu(0.5)

            Image {
                id: imgFavourite
                anchors.verticalCenter: labelTime.verticalCenter
                fillMode: Image.PreserveAspectCrop
                source: Qt.resolvedUrl("../icons_tmp/favorite-selected.svg")
                sourceSize.height: invalid ? 0 : (modelItem.favourite == "1" ? units.gu(1.5) : 0)
                visible: invalid ? false : (modelItem.favourite == "1")
            }

            Label {
                id: labelTime
                text: { invalid ? "" : DateUtils.formatRelativeTime(i18n, modelItem.pubdate) }
                fontSize: "x-small"
                width: parent.width - units.gu(1)
                wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                elide: Text.ElideRight
                maximumLineCount: 1
                opacity: 0.6
            }
        }

        Label {
            id: labelTitle

            text: invalid? "" : modelItem.title
            anchors {
                left: parent.left
                right: parent.right
            }
            height: parent.height - parent.spacing * 2 - labelTime.paintedHeight - label_feedname.paintedHeight
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
            fontSize: "small"
            textFormat: Text.PlainText
            font.weight: Font.DemiBold
            elide: Text.ElideRight
            opacity: invalid? 0.4 : (modelItem.status == "1" ? 0.4 : 0.8)
        }

        Label
        {
            id: label_feedname
            text: invalid? "" : modelItem.feed_name
            fontSize: "x-small"
            anchors {
                left: parent.left
                right: parent.right
            }
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
            opacity: 0.6
        }
    }

    MouseArea {
        anchors.fill: parent
        onClicked: {
            mainView.showArticle(rssModel, modelIndex)
        }
    }
}
